/*
 * Decompiled with CFR 0.152.
 */
package net.fckeditor;

import javax.servlet.http.HttpServletRequest;
import net.fckeditor.FCKeditorConfig;
import net.fckeditor.handlers.PropertiesLoader;
import net.fckeditor.tool.Compatibility;
import net.fckeditor.tool.Utils;
import net.fckeditor.tool.XHtmlTagTool;

public class FCKeditor {
    private FCKeditorConfig config;
    private String instanceName;
    private String value;
    private String basePath;
    private HttpServletRequest request;
    private String toolbarSet = PropertiesLoader.getProperty("fckeditor.toolbarSet");
    private String width = PropertiesLoader.getProperty("fckeditor.width");
    private String height = PropertiesLoader.getProperty("fckeditor.height");
    private String defaultBasePath = PropertiesLoader.getProperty("fckeditor.basePath");

    public FCKeditor(HttpServletRequest request, String instanceName, String width, String height, String toolbarSet, String value, String basePath) {
        this.request = request;
        this.instanceName = instanceName;
        if (Utils.isNotEmpty(width)) {
            this.width = width;
        }
        if (Utils.isNotEmpty(height)) {
            this.height = height;
        }
        if (Utils.isNotEmpty(toolbarSet)) {
            this.toolbarSet = toolbarSet;
        }
        if (Utils.isNotEmpty(value)) {
            this.value = value;
        }
        this.basePath = Utils.isNotEmpty(basePath) ? request.getContextPath().concat(basePath) : request.getContextPath().concat(this.defaultBasePath);
        this.config = new FCKeditorConfig();
    }

    public FCKeditor(HttpServletRequest request, String instanceName) {
        this(request, instanceName, null, null, null, null, null);
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setToolbarSet(String toolbarSet) {
        this.toolbarSet = toolbarSet;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public FCKeditorConfig getConfig() {
        return this.config;
    }

    public void setConfig(FCKeditorConfig config) {
        this.config = config;
    }

    private String escapeXml(String str) {
        if (Utils.isEmpty(str)) {
            return str;
        }
        str = str.replaceAll("&", "&#38;");
        str = str.replaceAll("<", "&#60;");
        str = str.replaceAll(">", "&#62;");
        str = str.replaceAll("\"", "&#34;");
        str = str.replaceAll("'", "&#39;");
        return str;
    }

    public String toString() {
        return this.createHtml();
    }

    public String createHtml() {
        StringBuffer strEditor = new StringBuffer();
        strEditor.append("<div>");
        String encodedValue = this.escapeXml(this.value.replaceAll("((\r?\n)+|\t*)", ""));
        if (Compatibility.check(this.request.getHeader("user-agent"))) {
            strEditor.append(this.createInputForVariable(this.instanceName, this.instanceName, encodedValue));
            String configStr = this.config.getUrlParams();
            if (Utils.isNotEmpty(configStr)) {
                strEditor.append(this.createInputForVariable(null, this.instanceName.concat("___Config"), configStr));
            }
            String sLink = this.basePath.concat("/editor/fckeditor.html?InstanceName=").concat(this.instanceName);
            if (Utils.isNotEmpty(this.toolbarSet)) {
                sLink = sLink + "&Toolbar=".concat(this.toolbarSet);
            }
            XHtmlTagTool iframeTag = new XHtmlTagTool("iframe", " ");
            iframeTag.addAttribute("id", this.instanceName.concat("___Frame"));
            iframeTag.addAttribute("src", sLink);
            iframeTag.addAttribute("width", this.width);
            iframeTag.addAttribute("height", this.height);
            iframeTag.addAttribute("frameborder", "no");
            iframeTag.addAttribute("scrolling", "no");
            strEditor.append(iframeTag);
        } else {
            XHtmlTagTool textareaTag = new XHtmlTagTool("textarea", encodedValue);
            textareaTag.addAttribute("name", this.instanceName);
            textareaTag.addAttribute("rows", "4");
            textareaTag.addAttribute("cols", "40");
            textareaTag.addAttribute("wrap", "virtual");
            textareaTag.addAttribute("style", "width: ".concat(this.width).concat("; height: ").concat(this.height));
        }
        strEditor.append("</div>");
        return strEditor.toString();
    }

    private String createInputForVariable(String name, String id, String value) {
        XHtmlTagTool tag = new XHtmlTagTool("input");
        if (Utils.isNotEmpty(id)) {
            tag.addAttribute("id", id);
        }
        if (Utils.isNotEmpty(name)) {
            tag.addAttribute("name", name);
        }
        tag.addAttribute("value", value);
        tag.addAttribute("type", "hidden");
        return tag.toString();
    }
}

