/*
 * Decompiled with CFR 0.152.
 */
package com.weishang.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weishang.pojo.Admin;
import com.weishang.pojo.AdminMod;
import com.weishang.pojo.Cms;
import com.weishang.pojo.Connect;
import com.weishang.pojo.Cooperation;
import com.weishang.pojo.Customer;
import com.weishang.pojo.Info;
import com.weishang.pojo.Recept;
import com.weishang.pojo.Role;
import com.weishang.pojo.Sign;
import com.weishang.pojo.Slide;
import com.weishang.pojo.Smtp;
import com.weishang.pojo.Template;
import com.weishang.pojo.User;
import com.weishang.pojo.UserAliply;
import com.weishang.pojo.UserType;
import com.weishang.tool.JdbcConnection;
import com.weishang.tool.TimeCalculate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AdminService {
    JdbcConnection jdbc = new JdbcConnection();

    public Admin login(String username, String pass) throws SQLException {
        Admin admin = new Admin();
        Object[] args = new String[]{username, pass};
        String sql = "select a.* from admin a where a.admin_username=? and a.admin_pass=?";
        ResultSet rs = this.jdbc.executeQuery(sql, args);
        while (rs.next()) {
            admin.setId(rs.getInt("admin_id"));
            admin.setUsername(rs.getString("admin_username"));
            admin.setRole(rs.getInt("admin_role"));
            admin.setAdminName(rs.getString("admin_name"));
        }
        this.jdbc.close();
        return admin;
    }

    public String getAllMod() throws SQLException {
        String json = "[";
        String sql = "select am.* from adminmod am order by am.adminmod_id asc";
        ResultSet rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            json = String.valueOf(json) + rs.getString("adminmod_code") + ",";
        }
        json = json.substring(0, json.length() - 1);
        json = String.valueOf(json) + "]";
        this.jdbc.close();
        return json;
    }

    public String getModByRole(String roleId) throws SQLException {
        String json = "[";
        String sql = "select am.* from rolemod rm,adminrole ar,adminmod am where am.adminmod_id=rm.mod_fk_id and ar.adminrole_id=rm.role_fk_id and ar.adminrole_id=? order by am.adminmod_id asc";
        ResultSet rs = this.jdbc.executeQuery(sql, roleId);
        while (rs.next()) {
            json = String.valueOf(json) + rs.getString("adminmod_code") + ",";
        }
        json = json.substring(0, json.length() - 1);
        json = String.valueOf(json) + "]";
        this.jdbc.close();
        return json;
    }

    public List<AdminMod> getUserMod(Integer roleId) throws SQLException {
        String sql = "select am.* from rolemod rd ,adminmod am,adminrole ar where ar.adminrole_id=? and ar.adminrole_id=rd.role_fk_id and am.adminmod_id=rd.mod_fk_id";
        ResultSet rs = this.jdbc.executeQuery(sql, roleId);
        AdminMod mod = null;
        ArrayList<AdminMod> modList = new ArrayList<AdminMod>();
        while (rs.next()) {
            Integer id = rs.getInt("adminmod_id");
            String code = rs.getString("adminmod_code");
            String css = rs.getString("adminmod_css");
            Integer parent = rs.getInt("adminmod_parent");
            JSONObject obj = (JSONObject)JSON.parse((String)code);
            String title = obj.get((Object)"text").toString();
            String url = obj.get((Object)"url").toString();
            Integer is_cms = rs.getInt("adminmod_is_cms");
            Integer style = rs.getInt("adminmod_style");
            Integer order = rs.getInt("adminmod_order");
            mod = new AdminMod(id, title, css, parent, url, is_cms, style, code, order);
            modList.add(mod);
        }
        this.jdbc.close();
        return modList;
    }

    public AdminMod getModById(String id) throws SQLException {
        String sql = "select am.* from adminmod am where am.adminmod_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, id);
        AdminMod mod = null;
        while (rs.next()) {
            Integer modid = rs.getInt("adminmod_id");
            String code = rs.getString("adminmod_code");
            String css = rs.getString("adminmod_css");
            Integer parent = rs.getInt("adminmod_parent");
            JSONObject obj = (JSONObject)JSON.parse((String)code);
            String title = obj.get((Object)"text").toString();
            String url = obj.get((Object)"url").toString();
            Integer is_cms = rs.getInt("adminmod_is_cms");
            Integer style = rs.getInt("adminmod_style");
            Integer order = rs.getInt("adminmod_order");
            mod = new AdminMod(modid, title, css, parent, url, is_cms, style, code, order);
        }
        this.jdbc.close();
        return mod;
    }

    public Admin getAdminbyId(Integer id) throws SQLException {
        String sql = "select a.*,ar.adminrole_name from admin a,adminrole ar where a.admin_role=ar.adminrole_id and a.admin_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, id);
        Admin admin = null;
        while (rs.next()) {
            admin = new Admin();
            admin.setId(rs.getInt("admin_id"));
            admin.setUsername(rs.getString("admin_username"));
            admin.setAdminName(rs.getString("admin_name"));
            admin.setAdminSex(rs.getString("admin_sex"));
            admin.setRoleName(rs.getString("adminrole_name"));
            admin.setRole(rs.getInt("admin_role"));
            admin.setQq(rs.getString("admin_qq"));
        }
        this.jdbc.close();
        return admin;
    }

    public List<Admin> getAllAdmin() throws SQLException {
        String sql = "select a.*,ar.adminrole_name from admin a,adminrole ar where a.admin_role=ar.adminrole_id order by a.admin_id asc";
        ResultSet rs = this.jdbc.executeQuery(sql);
        ArrayList<Admin> adminList = new ArrayList<Admin>();
        Admin admin = null;
        while (rs.next()) {
            admin = new Admin();
            admin.setId(rs.getInt("admin_id"));
            admin.setUsername(rs.getString("admin_username"));
            admin.setAdminName(rs.getString("admin_name"));
            admin.setAdminSex(rs.getString("admin_sex"));
            admin.setRoleName(rs.getString("adminrole_name"));
            admin.setQq(rs.getString("admin_qq"));
            adminList.add(admin);
        }
        this.jdbc.close();
        return adminList;
    }

    public String getAllAdminForSelect() throws SQLException {
        String json = "[";
        String sql = "select a.*,ar.adminrole_name from admin a,adminrole ar where a.admin_role=ar.adminrole_id order by a.admin_id asc";
        ResultSet rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            json = String.valueOf(json) + "{\"item\":\"" + rs.getString("admin_id") + "\",\"username\":\"" + rs.getString("admin_username") + "\",\"name\":\"" + rs.getString("admin_name") + "\",\"sex\":\"" + rs.getString("admin_sex") + "\",\"role\":\"" + rs.getString("adminrole_name") + "\"},";
        }
        json = json.substring(0, json.length() - 1);
        json = String.valueOf(json) + "]";
        this.jdbc.close();
        return json;
    }

    public List<Role> getAllRole() throws SQLException {
        String sql = "select ar.* from adminrole ar order by ar.adminrole_id asc";
        ResultSet rs = this.jdbc.executeQuery(sql);
        Role role = null;
        ArrayList<Role> roleList = new ArrayList<Role>();
        while (rs.next()) {
            role = new Role();
            role.setId(rs.getInt("adminrole_id"));
            role.setName(rs.getString("adminrole_name"));
            roleList.add(role);
        }
        this.jdbc.close();
        return roleList;
    }

    public Role getRoleById(Integer id) throws SQLException {
        String sql = "select ar.* from adminrole ar where ar.adminrole_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, id);
        Role role = new Role();
        if (rs.next()) {
            role.setId(rs.getInt("adminrole_id"));
            role.setName(rs.getString("adminrole_name"));
            this.jdbc.close();
            return role;
        }
        this.jdbc.close();
        return null;
    }

    public String saveRole(String name) {
        String sql = "insert into adminrole (adminrole_name) values(?)";
        int flag = this.jdbc.executeUpdate(sql, name);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateRole(String id, String name) {
        Object[] args = new Object[]{name, id};
        String sql = "UPDATE adminrole SET adminrole_name = ? where adminrole_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteRole(String roleId) {
        String sql = "DELETE FROM adminrole WHERE adminrole_id=?";
        int flag = this.jdbc.executeUpdate(sql, roleId);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteRoleByRole(String roleId) {
        String sql = "DELETE FROM rolemod WHERE role_fk_id=?";
        int flag = this.jdbc.executeUpdate(sql, roleId);
        this.jdbc.close();
        if (flag >= 0) {
            return "ok";
        }
        return "bad";
    }

    public String saveModByRole(String roleId, String modId) {
        Object[] args = new Object[]{modId, roleId};
        String sql = "insert into rolemod (mod_fk_id,role_fk_id) values(?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String getRoleName(String roleName) throws SQLException {
        String sql = "select ar.adminrole_id from adminrole ar where ar.adminrole_name=?";
        ResultSet rs = this.jdbc.executeQuery(sql, roleName);
        String adminrole_id = null;
        if (rs.next()) {
            adminrole_id = rs.getString("adminrole_id");
        }
        this.jdbc.close();
        return adminrole_id;
    }

    public boolean geyUser(String username) throws SQLException {
        String sql = "select a.admin_id from admin a where a.admin_username=?";
        ResultSet rs = this.jdbc.executeQuery(sql, username);
        if (rs.next()) {
            this.jdbc.close();
            return false;
        }
        this.jdbc.close();
        return true;
    }

    public String saveAdmin(String admin_username, String admin_pass, String admin_passbak, String admin_role, String admin_name, String admin_sex, String qq) {
        Object[] args = new Object[]{admin_username, admin_pass, admin_passbak, admin_role, admin_name, admin_sex, qq};
        String sql = "insert into admin (admin_username,admin_pass,admin_passbak,admin_role,admin_name,admin_sex,admin_qq) values(?,?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateAdmin(String id, String admin_role, String admin_name, String admin_sex, String qq) {
        Object[] args = new Object[]{admin_role, admin_name, admin_sex, qq, id};
        String sql = "UPDATE admin SET admin_role=?,admin_name=?,admin_sex=?,admin_qq=? where admin_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteAdmin(String adminid) {
        String sql = "DELETE FROM admin WHERE admin_id=?";
        int flag = this.jdbc.executeUpdate(sql, adminid);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String getNet() throws SQLException {
        String json = "[";
        String sql = "select n.* from net n";
        ResultSet rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            json = String.valueOf(json) + "{\"id\":\"" + rs.getString("net_id") + "\",\"tile\":\"" + rs.getString("net_tile") + "\",\"descript\":\"" + rs.getString("net_descript") + "\",\"keywords\":\"" + rs.getString("net_keywords") + "\",\"company\":\"" + rs.getString("net_company") + "\",\"copyright\":\"" + rs.getString("net_copyright") + "\",\"info\":\"" + rs.getString("net_info") + "\"},";
        }
        json = json.substring(0, json.length() - 1);
        json = String.valueOf(json) + "]";
        this.jdbc.close();
        return json;
    }

    public String updateNet(String tile, String descript, String keywords, String company, String copyright, String info, String logo, String tel) {
        Object[] args = new Object[]{tile, descript, keywords, company, copyright, info, logo, tel};
        String sql = "UPDATE net SET net_title=?,net_descript=?,net_keywords=?,net_company=?,net_copyright=?,net_info=?,net_logo=?,net_tel=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String getAllAuthorization(Integer pageNo, Integer pageSize, Integer flag, String admin) throws SQLException {
        String json = "[";
        String sql = "";
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        if (flag.equals(1)) {
            sql = "select a.* from authorization a order by a.authorization_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select a.* from authorization a where a.authorization_admin=? order by a.authorization_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql, admin);
        }
        while (rs.next()) {
            json = String.valueOf(json) + "{\"id\":\"" + rs.getString("authorization_id") + "\",\"www\":\"" + rs.getString("authorization_www") + "\",\"name\":\"" + rs.getString("authorization_name") + "\",\"user\":\"" + rs.getString("authorization_user") + "\",\"tel\":\"" + rs.getString("authorization_tel") + "\",\"qq\":\"" + rs.getString("authorization_qq") + "\",\"admin\":\"" + rs.getString("authorization_admin") + "\",\"price\":\"" + rs.getString("authorization_price") + "\",\"time\":\"" + rs.getString("authorization_time") + "\",\"endtime\":\"" + rs.getString("authorization_endtime") + "\"},";
        }
        json = json.substring(0, json.length() - 1);
        json = String.valueOf(json) + "]";
        this.jdbc.close();
        return json;
    }

    public Integer getAllAuthorizationCount(Integer flag, String admin) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        if (flag.equals(1)) {
            String sql = "select COUNT(*) AS rowcount from authorization ";
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            String sql = "select COUNT(*) AS rowcount from authorization where authorization_admin=?";
            rs = this.jdbc.executeQuery(sql, admin);
        }
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String saveNet(String www, String name, String user, String tel, String qq, String admin, Double price, String time, String endTime) {
        Object[] args = new Object[]{www, name, user, tel, qq, admin, price, time, endTime};
        String sql = "insert into authorization (authorization_www,authorization_name,authorization_user,authorization_tel,authorization_qq,authorization_admin,authorization_price,authorization_time,authorization_endtime) values(?,?,?,?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteNet(Integer id) {
        String sql = "DELETE FROM authorization WHERE authorization_id=?";
        int flag = this.jdbc.executeUpdate(sql, id);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String editNet(Integer id, String www, String name, String person, String tel, String qq, Double price, String time, String endtime) {
        Object[] args = new Object[]{www, name, person, tel, qq, price, time, endtime, id};
        String sql = "UPDATE authorization SET authorization_www=?,authorization_name=?,authorization_user=?,authorization_tel=?,authorization_qq=?,authorization_price=?,authorization_time=?,authorization_endtime=? where authorization_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Customer> getCustomerForPublic(Integer pageNo, Integer pageSize, Integer flag) throws SQLException {
        String sql = "";
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        sql = "select c.* from customer c where c.customer_flag=2 and c.customer_flag2=2 and c.customer_state!=4 and c.customer_state!=5 order by c.customer_id desc limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql);
        ArrayList<Customer> cusList = new ArrayList<Customer>();
        Customer cus = null;
        while (rs.next()) {
            cus = new Customer();
            cus.setId(rs.getInt("customer_id"));
            cus.setType(rs.getString("customer_type"));
            cus.setName(rs.getString("customer_name"));
            cus.setPerson(rs.getString("customer_person"));
            cus.setTel(rs.getString("customer_tel"));
            cus.setQq(rs.getString("customer_qq"));
            cus.setProduct(rs.getString("customer_product"));
            cus.setFlag(rs.getString("customer_flag"));
            cus.setFlag2(rs.getString("customer_flag2"));
            cus.setTime(rs.getString("customer_time"));
            cus.setTime1(rs.getString("customer_time1"));
            cus.setTime1_end(rs.getString("customer_time1_end"));
            cus.setTime2(rs.getString("customer_time2"));
            cus.setTime3(rs.getString("customer_time3"));
            cus.setUser(rs.getString("customer_user"));
            cus.setUser1(rs.getString("customer_user1"));
            cus.setUser3(rs.getString("customer_user3"));
            cus.setState(rs.getString("customer_state"));
            cus.setAdd_admin(rs.getString("customer_add_admin"));
            cus.setSuorce(rs.getString("customer_suorce"));
            cusList.add(cus);
        }
        this.jdbc.close();
        return cusList;
    }

    public Integer countCustomerForPublic(Integer flag) throws SQLException {
        int resultCount = 0;
        String sql = "select COUNT(*) AS rowcount from customer c where c.customer_flag=2 and c.customer_flag2=2 and c.customer_state!=4 and c.customer_state!=5";
        ResultSet rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public boolean getOrCustomer(String tel, String qq) throws SQLException {
        String sql = "";
        Object[] args = new String[]{tel, qq};
        sql = "select c.customer_id from customer c where c.customer_tel=? or c.customer_qq=?";
        ResultSet rs = null;
        rs = this.jdbc.executeQuery(sql, args);
        if (rs.next()) {
            this.jdbc.close();
            return true;
        }
        this.jdbc.close();
        return false;
    }

    public String updateCustomer(Integer id, Integer state, String time, String user) {
        Object[] args = new Object[]{state, time, user, id};
        Object[] args1 = new Object[]{state, id};
        String sql = "";
        int flag = -1;
        if (state.equals(4)) {
            sql = "UPDATE customer SET customer_state=?,customer_time3=?,customer_user3=? where customer_id=?";
            flag = this.jdbc.executeUpdate(sql, args);
        } else {
            sql = "UPDATE customer SET customer_state=? where customer_id=?";
            flag = this.jdbc.executeUpdate(sql, args1);
        }
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateCustomerForCrawl(Integer id, String time, String user) {
        Object[] args = new Object[]{time, user, id};
        String sql = "UPDATE customer SET customer_flag=1,customer_time=?,customer_user=? where customer_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String saveCustomer(String type, String name, String person, String tel, String qq, String product, String admin, String time, String suorce) {
        Object[] args = new Object[]{type, name, person, tel, qq, product, admin, time, suorce};
        String sql = "insert into customer (customer_type,customer_name,customer_person,customer_tel,customer_qq,customer_product,customer_add_admin,customer_time2,customer_suorce) values(?,?,?,?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String addConnect(Integer id, Integer user, String type, String conclusion, String time) {
        Object[] args = new Object[]{id, user, type, conclusion, time};
        String sql = "insert into customer_connect (customer_connect_customer,customer_connect_user,customer_connect_type,customer_connect_conclusion,customer_connect_time) values(?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Connect> lookConnect(Integer pageNo, Integer pageSize, Integer id) throws SQLException {
        String sql = "";
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        ArrayList<Connect> conList = new ArrayList<Connect>();
        Connect con = null;
        sql = "select cc.*,a.admin_username,a.admin_name from customer_connect cc,admin a where cc.customer_connect_user=a.admin_id and cc.customer_connect_customer=? order by cc.customer_connect_id desc limit " + offset + "," + sn;
        ResultSet rs = null;
        rs = this.jdbc.executeQuery(sql, id);
        while (rs.next()) {
            con = new Connect();
            con.setId(rs.getInt("customer_connect_id"));
            con.setType(rs.getString("customer_connect_type"));
            con.setConclusion(rs.getString("customer_connect_conclusion"));
            con.setTime(rs.getString("customer_connect_time"));
            con.setName(rs.getString("admin_name"));
            conList.add(con);
        }
        this.jdbc.close();
        return conList;
    }

    public Integer countConnect(Integer id) throws SQLException {
        Integer resultCount = 0;
        String sql = "select COUNT(*) AS rowcount from customer_connect cc,admin a where cc.customer_connect_user=a.admin_id and cc.customer_connect_customer=? ";
        ResultSet rs = this.jdbc.executeQuery(sql, id);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public boolean orCrawl(Integer id) throws SQLException {
        String sql = "";
        sql = "select c.* from customer c where c.customer_id=? and c.customer_flag=1";
        ResultSet rs = null;
        rs = this.jdbc.executeQuery(sql, id);
        return rs.next();
    }

    public String goCrawl(Integer id, String time, String user) {
        Object[] args = new Object[]{time, user};
        String sql = "UPDATE customer SET customer_flag=1,customer_time=?,customer_user=? where customer_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Integer getCrawlsCount(Integer id) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from grab where grab_user=?";
        rs = this.jdbc.executeQuery(sql, id);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public boolean culacur(Integer id, Integer user) throws SQLException {
        Date dDate;
        SimpleDateFormat format2;
        String time;
        TimeCalculate tc;
        Object[] args = new Object[]{id, user};
        String sql = "select g.grab_time from grab g where g.grab_customer=? and g.grab_user=?";
        ResultSet rs = null;
        rs = this.jdbc.executeQuery(sql, args);
        long days = 0L;
        if (rs.next() && (days = (tc = new TimeCalculate()).days(time = (format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(dDate = new Date()), rs.getString("grab_time"))) < 1L) {
            this.jdbc.close();
            return true;
        }
        this.jdbc.close();
        return false;
    }

    public String saveGraw(Integer user, Integer customer, String time) {
        Object[] args = new Object[]{user, customer, time};
        String sql = "insert into grab (grab_user,grab_customer,grab_time) values(?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Customer> getCrawlByUsername(Integer flag, Integer pageNo, Integer pageSize, String username) throws SQLException {
        String sql = "";
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        if (flag.equals(1)) {
            sql = "select c.* from customer c where c.customer_flag=1 and c.customer_flag2=2 and c.customer_state!=4 and c.customer_state!=5 order by c.customer_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select c.* from customer c where c.customer_flag=1 and c.customer_flag2=2 and c.customer_state!=4 and c.customer_state!=5 and c.customer_user=? order by c.customer_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql, username);
        }
        ArrayList<Customer> cusList = new ArrayList<Customer>();
        Customer cus = null;
        while (rs.next()) {
            cus = new Customer();
            cus.setId(rs.getInt("customer_id"));
            cus.setType(rs.getString("customer_type"));
            cus.setName(rs.getString("customer_name"));
            cus.setPerson(rs.getString("customer_person"));
            cus.setTel(rs.getString("customer_tel"));
            cus.setQq(rs.getString("customer_qq"));
            cus.setProduct(rs.getString("customer_product"));
            cus.setFlag(rs.getString("customer_flag"));
            cus.setFlag2(rs.getString("customer_flag2"));
            cus.setTime(rs.getString("customer_time"));
            cus.setTime1(rs.getString("customer_time1"));
            cus.setTime1_end(rs.getString("customer_time1_end"));
            cus.setTime2(rs.getString("customer_time2"));
            cus.setTime3(rs.getString("customer_time3"));
            cus.setUser(rs.getString("customer_user"));
            cus.setUser1(rs.getString("customer_user1"));
            cus.setUser3(rs.getString("customer_user3"));
            cus.setState(rs.getString("customer_state"));
            cus.setAdd_admin(rs.getString("customer_add_admin"));
            cus.setSuorce(rs.getString("customer_suorce"));
            cusList.add(cus);
        }
        this.jdbc.close();
        return cusList;
    }

    public Integer countCrawlByUsername(Integer flag, String username) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "";
        if (flag.equals(1)) {
            sql = "select COUNT(*) AS rowcount from customer c where c.customer_flag=1 and c.customer_flag2=2 and c.customer_state!=4 and c.customer_state!=5 ";
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select COUNT(*) AS rowcount from customer c where c.customer_flag=1 and c.customer_flag2=2 and c.customer_state!=4 and c.customer_state!=5 and c.customer_user=? ";
            rs = this.jdbc.executeQuery(sql, username);
        }
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String proCustomer(Integer id, Integer userid, String username, String time) throws ParseException {
        TimeCalculate tc = new TimeCalculate();
        Object[] args = new Object[]{time, username, tc.addTime(time, 30), id};
        Object[] args1 = new Object[]{id, userid, time};
        String sql = "insert into protection (protection_user,protection_customer,protection_time) values(?,?,?)";
        String sql1 = "UPDATE customer SET customer_flag2=1,customer_time1=?,customer_user1=?,customer_time1_end=? where customer_id=?";
        int flag = this.jdbc.executeUpdate(sql, args1);
        if (flag > 0) {
            int flag1 = this.jdbc.executeUpdate(sql1, args);
            if (flag1 > 0) {
                this.jdbc.close();
                return "ok";
            }
            this.jdbc.close();
            return "bad";
        }
        this.jdbc.close();
        return "bad";
    }

    public String GiveUp(Integer id) {
        Object[] objectArray = new Object[5];
        objectArray[4] = id;
        Object[] args = objectArray;
        String sql1 = "UPDATE customer SET customer_flag=2,customer_flag2=2,customer_time1=?,customer_time1_end=?,customer_user1=?,customer_user=? where customer_id=?";
        int flag1 = this.jdbc.executeUpdate(sql1, args);
        this.jdbc.close();
        if (flag1 > 0) {
            return "ok";
        }
        return "bad";
    }

    public Integer getProCount(Integer id) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from protection where protection_user=?";
        rs = this.jdbc.executeQuery(sql, id);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public List<Customer> getProtectionByUser(Integer flag, Integer pageNo, Integer pageSize, String username) throws SQLException {
        String sql = "";
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        if (flag.equals(1)) {
            sql = "select c.* from customer c where c.customer_flag=1 and c.customer_flag2=1 and c.customer_state!=4 and c.customer_state!=5 order by c.customer_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select c.* from customer c where c.customer_flag=1 and c.customer_flag2=1 and c.customer_state!=4 and c.customer_state!=5 and c.customer_user1=? order by c.customer_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql, username);
        }
        ArrayList<Customer> cusList = new ArrayList<Customer>();
        Customer cus = null;
        while (rs.next()) {
            cus = new Customer();
            cus.setId(rs.getInt("customer_id"));
            cus.setType(rs.getString("customer_type"));
            cus.setName(rs.getString("customer_name"));
            cus.setPerson(rs.getString("customer_person"));
            cus.setTel(rs.getString("customer_tel"));
            cus.setQq(rs.getString("customer_qq"));
            cus.setProduct(rs.getString("customer_product"));
            cus.setFlag(rs.getString("customer_flag"));
            cus.setFlag2(rs.getString("customer_flag2"));
            cus.setTime(rs.getString("customer_time"));
            cus.setTime1(rs.getString("customer_time1"));
            cus.setTime1_end(rs.getString("customer_time1_end"));
            cus.setTime2(rs.getString("customer_time2"));
            cus.setTime3(rs.getString("customer_time3"));
            cus.setUser(rs.getString("customer_user"));
            cus.setUser1(rs.getString("customer_user1"));
            cus.setUser3(rs.getString("customer_user3"));
            cus.setState(rs.getString("customer_state"));
            cus.setAdd_admin(rs.getString("customer_add_admin"));
            cus.setSuorce(rs.getString("customer_suorce"));
            cusList.add(cus);
        }
        this.jdbc.close();
        return cusList;
    }

    public Integer countProtectionByUser(Integer flag, String username) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "";
        if (flag.equals(1)) {
            sql = "select COUNT(*) AS rowcount from customer c where c.customer_flag=1 and c.customer_flag2=1 and c.customer_state!=4 and c.customer_state!=5";
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select COUNT(*) AS rowcount from customer c where c.customer_flag=1 and c.customer_flag2=1 and c.customer_state!=4 and c.customer_state!=5 and c.customer_user1=?";
            rs = this.jdbc.executeQuery(sql, username);
        }
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public List<Customer> getSignByUser(Integer flag, Integer pageNo, Integer pageSize, Integer user) throws SQLException {
        String sql = "";
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        if (flag.equals(1)) {
            sql = "select c.*,s.*,a.admin_username,a.admin_name from customer c,sign s,admin a where c.customer_id=s.sign_client and s.sign_user=a.admin_id and c.customer_state=4 order by s.sign_user1 asc, s.sign_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select c.*,s.*,a.admin_username,a.admin_name from customer c,sign s,admin a where c.customer_id=s.sign_client and s.sign_user=a.admin_id and c.customer_state=4 and s.sign_user=? order by s.sign_user1 asc,s.sign_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql, user);
        }
        ArrayList<Customer> cusList = new ArrayList<Customer>();
        Customer cus = null;
        Sign sign = null;
        while (rs.next()) {
            cus = new Customer();
            sign = new Sign();
            cus.setId(rs.getInt("customer_id"));
            cus.setType(rs.getString("customer_type"));
            cus.setName(rs.getString("customer_name"));
            cus.setPerson(rs.getString("customer_person"));
            cus.setTel(rs.getString("customer_tel"));
            cus.setQq(rs.getString("customer_qq"));
            cus.setProduct(rs.getString("customer_product"));
            cus.setFlag(rs.getString("customer_flag"));
            cus.setFlag2(rs.getString("customer_flag2"));
            cus.setTime(rs.getString("customer_time"));
            cus.setTime1(rs.getString("customer_time1"));
            cus.setTime1_end(rs.getString("customer_time1_end"));
            cus.setTime2(rs.getString("customer_time2"));
            cus.setTime3(rs.getString("customer_time3"));
            cus.setUser(rs.getString("customer_user"));
            cus.setUser1(rs.getString("customer_user1"));
            cus.setUser3(rs.getString("customer_user3"));
            cus.setState(rs.getString("customer_state"));
            cus.setAdd_admin(rs.getString("customer_add_admin"));
            cus.setSuorce(rs.getString("customer_suorce"));
            sign.setClient(rs.getInt("sign_client"));
            sign.setUser(rs.getInt("sign_client"));
            sign.setContent(rs.getString("sign_content"));
            sign.setPrice(rs.getString("sign_price"));
            sign.setTime(rs.getString("sign_time"));
            sign.setUser1(rs.getInt("sign_user1"));
            sign.setTime1(rs.getString("sign_time1"));
            cus.setSign(sign);
            cusList.add(cus);
        }
        this.jdbc.close();
        return cusList;
    }

    public Integer countSignByUser(Integer flag, Integer user) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "";
        if (flag.equals(1)) {
            sql = "select COUNT(*) AS rowcount from customer c,sign s,admin a where c.customer_id=s.sign_client and s.sign_user=a.admin_id and c.customer_state=4";
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select COUNT(*) AS rowcount from customer c,sign s,admin a where c.customer_id=s.sign_client and s.sign_user=a.admin_id and c.customer_state=4 and s.sign_user=?";
            rs = this.jdbc.executeQuery(sql, user);
        }
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public List<Customer> getGiveUpByUser(Integer flag, Integer pageNo, Integer pageSize, String username) throws SQLException {
        String sql = "";
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        if (flag.equals(1)) {
            sql = "select c.* from customer c where c.customer_state=5 order by  c.customer_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select c.* from customer c where c.customer_state=5 and c.customer_user3=? order by c.customer_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql, username);
        }
        ArrayList<Customer> cusList = new ArrayList<Customer>();
        Customer cus = null;
        while (rs.next()) {
            cus = new Customer();
            cus.setId(rs.getInt("customer_id"));
            cus.setType(rs.getString("customer_type"));
            cus.setName(rs.getString("customer_name"));
            cus.setPerson(rs.getString("customer_person"));
            cus.setTel(rs.getString("customer_tel"));
            cus.setQq(rs.getString("customer_qq"));
            cus.setProduct(rs.getString("customer_product"));
            cus.setFlag(rs.getString("customer_flag"));
            cus.setFlag2(rs.getString("customer_flag2"));
            cus.setTime(rs.getString("customer_time"));
            cus.setTime1(rs.getString("customer_time1"));
            cus.setTime1_end(rs.getString("customer_time1_end"));
            cus.setTime2(rs.getString("customer_time2"));
            cus.setTime3(rs.getString("customer_time3"));
            cus.setUser(rs.getString("customer_user"));
            cus.setUser1(rs.getString("customer_user1"));
            cus.setUser3(rs.getString("customer_user3"));
            cus.setState(rs.getString("customer_state"));
            cus.setAdd_admin(rs.getString("customer_add_admin"));
            cus.setSuorce(rs.getString("customer_suorce"));
            cusList.add(cus);
        }
        this.jdbc.close();
        return cusList;
    }

    public Integer countGiveUpByUser(Integer flag, String username) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "";
        if (flag.equals(1)) {
            sql = "select COUNT(*) AS rowcount from customer c where c.customer_state=5 ";
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select COUNT(*) AS rowcount from customer c where c.customer_state=5 and c.customer_user3=?";
            rs = this.jdbc.executeQuery(sql, username);
        }
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String addSign(Integer cid, Integer uid, String content, double price) {
        TimeCalculate tc = new TimeCalculate();
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dDate = new Date();
        String time = format2.format(dDate);
        Object[] args = new Object[]{cid, uid, content, price, time};
        String sql = "insert into sign (sign_client,sign_user,sign_content,sign_price,sign_time) values(?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Admin> getAllocation() throws SQLException {
        String sql = "select a.* from admin a where a.admin_role=17 order by a.admin_id asc";
        ResultSet rs = this.jdbc.executeQuery(sql);
        ArrayList<Admin> adminList = new ArrayList<Admin>();
        Admin admin = null;
        while (rs.next()) {
            admin = new Admin();
            admin.setId(rs.getInt("admin_id"));
            admin.setUsername(rs.getString("admin_username"));
            admin.setAdminName(rs.getString("admin_name"));
            admin.setAdminSex(rs.getString("admin_sex"));
            admin.setQq(rs.getString("admin_qq"));
            adminList.add(admin);
        }
        this.jdbc.close();
        return adminList;
    }

    public String updatesignForAllocation(Integer id, Integer uid) {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dDate = new Date();
        String time = format2.format(dDate);
        Object[] args = new Object[]{uid, time, id};
        String sql = "UPDATE sign SET sign_user1=?,sign_time1=? where sign_id=?";
        int flag1 = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag1 > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Customer> getCustomerService(Integer flag, Integer pageNo, Integer pageSize, Integer uid) throws SQLException {
        String json = "[";
        String sql = "";
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        if (flag.equals(1)) {
            sql = "select c.*,s.*,a.admin_username,a.admin_name from customer c,sign s,admin a where c.customer_id=s.sign_client and s.sign_user1=a.admin_id and c.customer_state=4 order by s.sign_user1 asc, s.sign_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select c.*,s.*,a.admin_username,a.admin_name from customer c,sign s,admin a where c.customer_id=s.sign_client and s.sign_user1=a.admin_id and c.customer_state=4 and s.sign_user1=? order by s.sign_user1 asc,s.sign_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql, uid);
        }
        ArrayList<Customer> cusList = new ArrayList<Customer>();
        Customer cus = null;
        Sign sign = null;
        while (rs.next()) {
            cus = new Customer();
            sign = new Sign();
            cus.setId(rs.getInt("customer_id"));
            cus.setType(rs.getString("customer_type"));
            cus.setName(rs.getString("customer_name"));
            cus.setPerson(rs.getString("customer_person"));
            cus.setTel(rs.getString("customer_tel"));
            cus.setQq(rs.getString("customer_qq"));
            cus.setProduct(rs.getString("customer_product"));
            cus.setFlag(rs.getString("customer_flag"));
            cus.setFlag2(rs.getString("customer_flag2"));
            cus.setTime(rs.getString("customer_time"));
            cus.setTime1(rs.getString("customer_time1"));
            cus.setTime1_end(rs.getString("customer_time1_end"));
            cus.setTime2(rs.getString("customer_time2"));
            cus.setTime3(rs.getString("customer_time3"));
            cus.setUser(rs.getString("customer_user"));
            cus.setUser1(rs.getString("customer_user1"));
            cus.setUser3(rs.getString("customer_user3"));
            cus.setState(rs.getString("customer_state"));
            cus.setAdd_admin(rs.getString("customer_add_admin"));
            cus.setSuorce(rs.getString("customer_suorce"));
            sign.setClient(rs.getInt("sign_client"));
            sign.setUser(rs.getInt("sign_client"));
            sign.setContent(rs.getString("sign_content"));
            sign.setPrice(rs.getString("sign_price"));
            sign.setTime(rs.getString("sign_time"));
            sign.setUser1(rs.getInt("sign_user1"));
            sign.setTime1(rs.getString("sign_time1"));
            cus.setSign(sign);
            cusList.add(cus);
        }
        this.jdbc.close();
        return cusList;
    }

    public Integer countCustomerService(Integer flag, Integer uid) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "";
        if (flag.equals(1)) {
            sql = "select COUNT(*) AS rowcount from customer c,sign s,admin a where c.customer_id=s.sign_client and s.sign_user1=a.admin_id and c.customer_state=4";
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select COUNT(*) AS rowcount from customer c,sign s,admin a where c.customer_id=s.sign_client and s.sign_user1=a.admin_id and c.customer_state=4 and s.sign_user1=?";
            rs = this.jdbc.executeQuery(sql, uid);
        }
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public boolean getOrAlipy(Integer user, Integer customer) throws SQLException {
        Object[] args = new Object[]{user, customer};
        String sql = "select aa.apply_admin_id from apply_admin aa where aa.apply_admin_user=? and aa.apply_admin_customer=? ";
        ResultSet rs = null;
        rs = this.jdbc.executeQuery(sql, args);
        if (rs.next()) {
            this.jdbc.close();
            return true;
        }
        this.jdbc.close();
        return false;
    }

    public String addAlipy(Integer user, Integer customer) {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date dDate = new Date();
        String time = format2.format(dDate);
        Object[] args = new Object[]{user, customer, 0, time};
        String sql = "insert into apply_admin (apply_admin_user,apply_admin_customer,apply_admin_flag,apply_admin_time) values(?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Customer> getAlipyForUser(Integer flag, Integer pageNo, Integer pageSize, Integer uid) throws SQLException {
        String sql = "";
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        if (flag.equals(1)) {
            sql = "select c.customer_time1_end,c.customer_id,c.customer_type,c.customer_name,c.customer_person,c.customer_tel,c.customer_qq,aa.*,a.admin_name,a.admin_username from customer c,apply_admin aa,admin a where aa.apply_admin_user=a.admin_id and aa.apply_admin_customer=c.customer_id order by aa.apply_admin_flag asc,aa.apply_admin_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select c.customer_time1_end,c.customer_id,c.customer_type,c.customer_name,c.customer_person,c.customer_tel,c.customer_qq,aa.*,a.admin_name,a.admin_username from customer c,apply_admin aa,admin a where aa.apply_admin_user=a.admin_id and aa.apply_admin_customer=c.customer_id and aa.apply_admin_user=? order by aa.apply_admin_flag asc,aa.apply_admin_id desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql, uid);
        }
        ArrayList<Customer> cusList = new ArrayList<Customer>();
        Customer cus = null;
        UserAliply ua = null;
        while (rs.next()) {
            cus = new Customer();
            ua = new UserAliply();
            cus.setId(rs.getInt("customer_id"));
            cus.setTime1_end(rs.getString("customer_time1_end"));
            cus.setType(rs.getString("customer_type"));
            cus.setName(rs.getString("customer_name"));
            cus.setPerson(rs.getString("customer_person"));
            cus.setTel(rs.getString("customer_tel"));
            cus.setQq(rs.getString("customer_qq"));
            ua.setId(rs.getInt("apply_admin_id"));
            ua.setReason(rs.getString("apply_admin_reason"));
            ua.setDay(rs.getInt("apply_admin_day"));
            ua.setTime(rs.getString("apply_admin_time"));
            ua.setUser(rs.getString("admin_name"));
            ua.setFlag(rs.getInt("apply_admin_flag"));
            cus.setUserAliply(ua);
            cusList.add(cus);
        }
        this.jdbc.close();
        return cusList;
    }

    public Integer countAlipyForUser(Integer flag, Integer uid) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "";
        if (flag.equals(1)) {
            sql = "select COUNT(*) AS rowcount from customer c,apply_admin aa,admin a where aa.apply_admin_user=a.admin_id and aa.apply_admin_customer=c.customer_id";
            rs = this.jdbc.executeQuery(sql);
        } else if (flag.equals(2)) {
            sql = "select COUNT(*) AS rowcount from customer c,apply_admin aa,admin a where aa.apply_admin_user=a.admin_id and aa.apply_admin_customer=c.customer_id and aa.apply_admin_user=?";
            rs = this.jdbc.executeQuery(sql, uid);
        }
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String alipyExtension(Integer flag, String content, String endTiem, Integer aid, Integer cid, Integer days) throws ParseException {
        String sql = "update apply_admin SET apply_admin_flag=?,apply_admin_reason=? where apply_admin_id=?";
        String sql1 = "update customer SET customer_time1_end=? where customer_id=?";
        if (flag.equals(1)) {
            Object[] args = new Object[]{flag, content, aid};
            TimeCalculate tc = new TimeCalculate();
            Object[] args1 = new Object[]{tc.addTime(endTiem, days), cid};
            this.jdbc.executeUpdate(sql, args);
            this.jdbc.executeUpdate(sql1, args1);
        } else if (flag.equals(2)) {
            Object[] args = new Object[]{flag, content, aid};
            this.jdbc.executeUpdate(sql, args);
        }
        this.jdbc.close();
        return "ok";
    }

    public String addCooperation(String name, String url, String img, Integer order, Integer type) {
        Object[] args = new Object[]{name, url, img, order, type};
        String sql = "insert into cooperation (case_name,case_url,case_img,case_order,case_type) values(?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteCooperation(Integer id) {
        String sql = "DELETE FROM cooperation WHERE case_id=?";
        int flag = this.jdbc.executeUpdate(sql, id);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Cooperation> getCooperation(Integer pageNo, Integer pageSize, String flag) throws SQLException {
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        String sql = "select c.* from cooperation c where c.case_type=? order by c.case_order desc limit " + offset + "," + sn;
        rs = this.jdbc.executeQuery(sql, flag);
        Cooperation coo = null;
        ArrayList<Cooperation> cooList = new ArrayList<Cooperation>();
        while (rs.next()) {
            coo = new Cooperation(rs.getInt("case_id"), rs.getString("case_name"), rs.getString("case_url"), rs.getString("case_img"));
            cooList.add(coo);
        }
        this.jdbc.close();
        return cooList;
    }

    public Integer getCooperationSum(String flag) throws SQLException {
        int resultCount = 0;
        String sql = "select COUNT(*) AS rowcount from cooperation c where c.case_type=?";
        ResultSet rs = this.jdbc.executeQuery(sql, flag);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String updateFileName(String name) {
        String sql = "update temp SET temp_name=?";
        int flag = this.jdbc.executeUpdate(sql, name);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String getFileName() throws SQLException {
        String sql = "select t.* from temp t";
        ResultSet rs = this.jdbc.executeQuery(sql);
        String filename = "";
        if (rs.next()) {
            filename = rs.getString("temp_name");
        }
        this.jdbc.close();
        return filename;
    }

    public String updatePass(Integer id, String passbak, String pass) {
        Object[] args = new Object[]{pass, passbak, id};
        String sql = "update admin SET admin_pass=?,admin_passbak=? where admin_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Customer> getScan() throws SQLException {
        ArrayList<Customer> cumtomerList = new ArrayList<Customer>();
        ResultSet rs = null;
        String sql = "select c.customer_id,c.customer_flag,c.customer_flag2,c.customer_time,c.customer_time1_end from customer c where c.customer_flag=1 or c.customer_flag2=1 and c.customer_state!=4 and c.customer_state!=5 order by c.customer_id desc";
        rs = this.jdbc.executeQuery(sql);
        Customer cu = null;
        while (rs.next()) {
            cu = new Customer();
            cu.setId(rs.getInt("customer_id"));
            cu.setTime(rs.getString("customer_time"));
            cu.setTime1_end(rs.getString("customer_time1_end"));
            cu.setFlag(rs.getString("customer_flag"));
            cu.setFlag2(rs.getString("customer_flag2"));
            cumtomerList.add(cu);
        }
        this.jdbc.close();
        return cumtomerList;
    }

    public List<Cms> getCmsByPage(Integer pageNo, Integer pageSize, Integer tid) throws SQLException {
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        ArrayList<Cms> cmsList = new ArrayList<Cms>();
        String sql = "select c.*,am.* from cms c,adminmod am where c.cms_admin_mod=am.adminmod_id and c.cms_admin_mod=? order by c.cms_flag desc,c.cms_order desc limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql, tid);
        Cms cms = null;
        while (rs.next()) {
            cms = new Cms();
            cms.setId(rs.getInt("cms_id"));
            cms.setName(rs.getString("cms_name"));
            cms.setStyle(rs.getString("cms_style"));
            cms.setSuroce(rs.getString("cms_suroce"));
            cms.setPerson(rs.getString("cms_peron"));
            cms.setContent(rs.getString("cms_content"));
            cms.setTime(rs.getString("cms_time"));
            cms.setMod(rs.getInt("adminmod_id"));
            String code = rs.getString("adminmod_code");
            JSONObject obj = (JSONObject)JSON.parse((String)code);
            String title = obj.get((Object)"text").toString();
            cms.setModName(title);
            cms.setFlag(rs.getString("cms_flag"));
            cms.setOrder(rs.getInt("cms_order"));
            cms.setImg(rs.getString("cms_img"));
            cms.setDescription(rs.getString("cms_description"));
            cms.setKeyword(rs.getString("cms_keyword"));
            cms.setSpare1(rs.getString("cms_spare1"));
            cmsList.add(cms);
        }
        this.jdbc.close();
        return cmsList;
    }

    public Integer countCmsByMod(Integer id) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from cms c,adminmod am where c.cms_admin_mod=am.adminmod_id and c.cms_admin_mod=?";
        rs = this.jdbc.executeQuery(sql, id);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public Cms getCmsByModId(Integer id) throws SQLException {
        ResultSet rs = null;
        String sql = "select c.* from cms c where c.cms_admin_mod=? ";
        rs = this.jdbc.executeQuery(sql, id);
        Cms cms = null;
        if (rs.next()) {
            cms = new Cms();
            cms.setId(rs.getInt("cms_id"));
            cms.setName(rs.getString("cms_name"));
            cms.setStyle(rs.getString("cms_style"));
            cms.setSuroce(rs.getString("cms_suroce"));
            cms.setPerson(rs.getString("cms_peron"));
            cms.setContent(rs.getString("cms_content"));
            cms.setTime(rs.getString("cms_time"));
            cms.setFlag(rs.getString("cms_flag"));
            cms.setOrder(rs.getInt("cms_order"));
            cms.setImg(rs.getString("cms_img"));
            cms.setDescription(rs.getString("cms_description"));
            cms.setKeyword(rs.getString("cms_keyword"));
            cms.setSpare1(rs.getString("cms_spare1"));
        }
        this.jdbc.close();
        return cms;
    }

    public Cms getCmsById(Integer id) throws SQLException {
        ResultSet rs = null;
        String sql = "select c.* from cms c where c.cms_id=? ";
        rs = this.jdbc.executeQuery(sql, id);
        Cms cms = null;
        if (rs.next()) {
            cms = new Cms();
            cms.setId(rs.getInt("cms_id"));
            cms.setName(rs.getString("cms_name"));
            cms.setStyle(rs.getString("cms_style"));
            cms.setSuroce(rs.getString("cms_suroce"));
            cms.setPerson(rs.getString("cms_peron"));
            cms.setContent(rs.getString("cms_content"));
            cms.setTime(rs.getString("cms_time"));
            cms.setFlag(rs.getString("cms_flag"));
            cms.setOrder(rs.getInt("cms_order"));
            cms.setImg(rs.getString("cms_img"));
            cms.setDescription(rs.getString("cms_description"));
            cms.setKeyword(rs.getString("cms_keyword"));
            cms.setMod(rs.getInt("cms_admin_mod"));
            cms.setSpare1(rs.getString("cms_spare1"));
        }
        this.jdbc.close();
        return cms;
    }

    public String addCms(String name, String style, String suroce, String person, String content, String time, String type, String flag, String order, String img, String descript, String keyword, String spare1) {
        Object[] args = new Object[]{name, style, suroce, person, content, time, type, flag, order, img, descript, keyword, spare1};
        String sql = "insert into cms (cms_name,cms_style,cms_suroce,cms_peron,cms_content,cms_time,cms_admin_mod,cms_flag,cms_order,cms_img,cms_description,cms_keyword,cms_spare1) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        int o = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (o > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteCms(Integer id) {
        String sql = "DELETE FROM cms WHERE cms_id=?";
        int flag = this.jdbc.executeUpdate(sql, id);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateCms(String id, String name, String suroce, String person, String content, String type, String flag, String order, String img, String descript, String keyword, String spare1) {
        Object[] args = new Object[]{name, suroce, person, content, type, flag, order, img, descript, keyword, spare1, id};
        String sql = "update cms SET cms_name=?,cms_suroce=?,cms_peron=?,cms_content=?,cms_admin_mod=?,cms_flag=?,cms_order=?,cms_img=?,cms_description=?,cms_keyword=?,cms_spare1=? where cms_id=?";
        int tem = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (tem > 0) {
            return "ok";
        }
        return "bad";
    }

    public String getCmsType() throws SQLException {
        String json = "[";
        String sql = "select ct.* from cms_type ct ";
        ResultSet rs = null;
        rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            json = String.valueOf(json) + "{\"cms_type_id\":\"" + rs.getString("cms_type_id") + "\",\"cms_type_bak_id\":\"" + rs.getString("cms_type_id") + "\",\"cms_type_name\":\"" + rs.getString("cms_type_name") + "\",\"cms_type_title\":\"" + rs.getString("cms_type_title") + "\",\"cms_type_keyword\":\"" + rs.getString("cms_type_keyword") + "\",\"cms_type_descript\":\"" + rs.getString("cms_type_descript") + "\"},";
        }
        json = json.substring(0, json.length() - 1);
        json = String.valueOf(json) + "]";
        this.jdbc.close();
        return json;
    }

    public String updateCmsType(Integer id, String name, String title, String keywords, String descript) {
        Object[] args = new Object[]{name, title, keywords, descript, id};
        String sql = "update cms_type SET cms_type_name=?,cms_type_title=?,cms_type_keyword=?,cms_type_descript=? where cms_type_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Slide getSlideById(String id) throws SQLException {
        String sql = "select s.* from slide s where s.slide_id=? order by s.slide_order desc";
        ResultSet rs = null;
        Slide slide = null;
        rs = this.jdbc.executeQuery(sql, id);
        if (rs.next()) {
            slide = new Slide();
            slide.setId(rs.getInt("slide_id"));
            slide.setTitle(rs.getString("slide_title"));
            slide.setUrl(rs.getString("slide_url"));
            slide.setOrder(rs.getString("slide_order"));
            slide.setImg(rs.getString("slide_img"));
        }
        this.jdbc.close();
        return slide;
    }

    public List<Slide> getSlide() throws SQLException {
        String sql = "select s.* from slide s order by s.slide_order desc";
        ResultSet rs = null;
        ArrayList<Slide> slideList = new ArrayList<Slide>();
        Slide slide = null;
        rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            slide = new Slide();
            slide.setId(rs.getInt("slide_id"));
            slide.setTitle(rs.getString("slide_title"));
            slide.setUrl(rs.getString("slide_url"));
            slide.setOrder(rs.getString("slide_order"));
            slide.setImg(rs.getString("slide_img"));
            slideList.add(slide);
        }
        this.jdbc.close();
        return slideList;
    }

    public String addSlide(String title, String img, String url, String order) {
        Object[] args = new Object[]{title, img, url, order};
        String sql = "insert into slide (slide_title,slide_img,slide_url,slide_order) values(?,?,?,?)";
        int o = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (o > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteSlide(String id) {
        String sql = "DELETE FROM slide WHERE slide_id=?";
        int flag = this.jdbc.executeUpdate(sql, id);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateSlide(String id, String title, String img, String url, String order) {
        Object[] args = new Object[]{title, img, url, order, id};
        String sql = "update slide SET slide_title=?,slide_img=?,slide_url=?,slide_order=? where slide_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String getColumnOrder() throws SQLException {
        String json = "[";
        String sql = "select co.* from column_order co ";
        ResultSet rs = null;
        rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            json = String.valueOf(json) + "{\"id\":\"" + rs.getString("column_order_id") + "\",\"bak_id\":\"" + rs.getString("column_order_id") + "\",\"name\":\"" + rs.getString("column_order_name") + "\",\"title\":\"" + rs.getString("column_order_title") + "\",\"keywords\":\"" + rs.getString("column_order_keywords") + "\",\"descrip\":\"" + rs.getString("column_order_descript") + "\"},";
        }
        json = json.substring(0, json.length() - 1);
        json = String.valueOf(json) + "]";
        this.jdbc.close();
        return json;
    }

    public String updateColumnOrder(Integer id, String name, String title, String keywords, String descript) {
        Object[] args = new Object[]{name, title, keywords, descript, id};
        String sql = "update column_order SET column_order_name=?,column_order_title=?,column_order_keywords=?,column_order_descript=? where column_order_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String diguitree(ArrayList list, Integer roleId) throws SQLException {
        String mlt = "\"leaf\":\"false\",";
        mlt = String.valueOf(mlt) + "\"children\":[";
        for (Object obj : list) {
            AdminMod mp = (AdminMod)obj;
            mlt = String.valueOf(mlt) + "{\"id\":\"" + mp.getId() + "\",";
            mlt = String.valueOf(mlt) + "\"name\":\"" + mp.getTitle() + "\",";
            mlt = String.valueOf(mlt) + "\"css\":\"" + mp.getCss() + "\",";
            mlt = String.valueOf(mlt) + "\"url\":\"" + mp.getUrl() + "\",";
            mlt = String.valueOf(mlt) + "\"style\":\"" + mp.getStyle() + "\",";
            mlt = String.valueOf(mlt) + "\"is_not_cms\":\"" + mp.getIs_not_cms() + "\",";
            mlt = String.valueOf(mlt) + "\"parentId\":\"" + mp.getParent() + "\",";
            Object[] args = new Object[]{roleId, mp.getId()};
            String sql = "select am.* from rolemod rd ,adminmod am,adminrole ar where ar.adminrole_id=? and am.adminmod_parent=? and ar.adminrole_id=rd.role_fk_id and am.adminmod_id=rd.mod_fk_id order by am.adminmod_order desc";
            ResultSet rs = this.jdbc.executeQuery(sql, args);
            AdminMod mod = null;
            ArrayList<AdminMod> modList = new ArrayList<AdminMod>();
            while (rs.next()) {
                Integer id = rs.getInt("adminmod_id");
                String code = rs.getString("adminmod_code");
                String css = rs.getString("adminmod_css");
                Integer parent = rs.getInt("adminmod_parent");
                JSONObject obj1 = (JSONObject)JSON.parse((String)code);
                String title = obj1.get((Object)"text").toString();
                String url = obj1.get((Object)"url").toString();
                Integer is_cms = rs.getInt("adminmod_is_cms");
                Integer style = rs.getInt("adminmod_style");
                Integer order = rs.getInt("adminmod_order");
                mod = new AdminMod(id, title, css, parent, url, is_cms, style, code, order);
                modList.add(mod);
            }
            mlt = modList != null && modList.size() > 0 ? String.valueOf(mlt) + this.diguitree(modList, roleId) : mlt.substring(0, mlt.length() - 1);
            mlt = String.valueOf(mlt) + "},";
        }
        mlt = mlt.substring(0, mlt.length() - 1);
        mlt = String.valueOf(mlt) + "],";
        mlt = mlt.substring(0, mlt.length() - 1);
        this.jdbc.close();
        return mlt;
    }

    public String sqltree(Integer roleId) throws SQLException {
        String sql1 = "select am.* from rolemod rd ,adminmod am,adminrole ar where ar.adminrole_id=? and am.adminmod_parent =0 and ar.adminrole_id=rd.role_fk_id and am.adminmod_id=rd.mod_fk_id order by am.adminmod_order desc";
        ResultSet rs = this.jdbc.executeQuery(sql1, roleId);
        AdminMod mod = null;
        ArrayList<AdminMod> modList1 = new ArrayList<AdminMod>();
        while (rs.next()) {
            Integer id = rs.getInt("adminmod_id");
            String string = rs.getString("adminmod_code");
            String css = rs.getString("adminmod_css");
            Integer parent = rs.getInt("adminmod_parent");
            JSONObject obj1 = (JSONObject)JSON.parse((String)string);
            String title = obj1.get((Object)"text").toString();
            String url = obj1.get((Object)"url").toString();
            Integer is_cms = rs.getInt("adminmod_is_cms");
            Integer style = rs.getInt("adminmod_style");
            Integer order = rs.getInt("adminmod_order");
            mod = new AdminMod(id, title, css, parent, url, is_cms, style, string, order);
            modList1.add(mod);
        }
        String mlt = "[";
        for (Object e : modList1) {
            AdminMod mp = (AdminMod)e;
            if (!mp.getParent().equals(0)) continue;
            mlt = String.valueOf(mlt) + "{\"id\":\"" + mp.getId() + "\",";
            mlt = String.valueOf(mlt) + "\"name\":\"" + mp.getTitle() + "\",";
            mlt = String.valueOf(mlt) + "\"css\":\"" + mp.getCss() + "\",";
            mlt = String.valueOf(mlt) + "\"url\":\"" + mp.getUrl() + "\",";
            mlt = String.valueOf(mlt) + "\"style\":\"" + mp.getStyle() + "\",";
            mlt = String.valueOf(mlt) + "\"is_not_cms\":\"" + mp.getIs_not_cms() + "\",";
            mlt = String.valueOf(mlt) + "\"parentId\":\"null\",";
            String sql = "select am.* from rolemod rd ,adminmod am,adminrole ar where ar.adminrole_id=? and am.adminmod_parent=? and ar.adminrole_id=rd.role_fk_id and am.adminmod_id=rd.mod_fk_id order by am.adminmod_order desc";
            Object[] args = new Object[]{roleId, mp.getId()};
            ResultSet rs1 = this.jdbc.executeQuery(sql, args);
            ArrayList<AdminMod> modList2 = new ArrayList<AdminMod>();
            while (rs1.next()) {
                Integer id = rs1.getInt("adminmod_id");
                String code = rs1.getString("adminmod_code");
                String css = rs1.getString("adminmod_css");
                Integer parent = rs1.getInt("adminmod_parent");
                JSONObject obj1 = (JSONObject)JSON.parse((String)code);
                String title = obj1.get((Object)"text").toString();
                String url = obj1.get((Object)"url").toString();
                Integer is_cms = rs1.getInt("adminmod_is_cms");
                Integer style = rs1.getInt("adminmod_style");
                Integer order = rs1.getInt("adminmod_order");
                mp = new AdminMod(id, title, css, parent, url, is_cms, style, code, order);
                modList2.add(mp);
            }
            mlt = modList2 != null && modList2.size() > 0 ? String.valueOf(mlt) + this.diguitree(modList2, roleId) : mlt.substring(0, mlt.length() - 1);
            mlt = String.valueOf(mlt) + "},";
        }
        mlt = mlt.substring(0, mlt.length() - 1);
        mlt = String.valueOf(mlt) + "]";
        this.jdbc.close();
        return mlt;
    }

    public List<Template> getAllTemplate() throws SQLException {
        ArrayList<Template> tplList = new ArrayList<Template>();
        ResultSet rs = null;
        Template tpl = null;
        String sql = "select t.* from tpl t";
        rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            tpl = new Template();
            tpl.setId(rs.getInt("tpl_id"));
            tpl.setFlag(rs.getInt("tpl_flag"));
            tpl.setFolder(rs.getString("tpl_folder"));
            tpl.setName(rs.getString("tpl_name"));
            tplList.add(tpl);
        }
        this.jdbc.close();
        return tplList;
    }

    public String updateTemplate(Integer flag, Integer id) {
        Object[] args = new Integer[]{flag, id};
        String sql = "UPDATE tpl SET tpl_flag = ? where tpl_id=?";
        int o = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (o > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateTemplate() {
        String sql = "UPDATE tpl SET tpl_flag = 2";
        int o = this.jdbc.executeUpdate(sql);
        this.jdbc.close();
        if (o > 0) {
            return "ok";
        }
        return "bad";
    }

    public Smtp getSmtp() throws SQLException {
        String sql = "select s.* from smtp s";
        ResultSet rs = null;
        rs = this.jdbc.executeQuery(sql);
        Smtp smtp = new Smtp();
        if (rs.next()) {
            smtp.setId(rs.getInt("smtp_id"));
            smtp.setAddress(rs.getString("smtp_address"));
            smtp.setFrom(rs.getString("smtp_from"));
            smtp.setUser(rs.getString("smtp_user"));
            smtp.setPass(rs.getString("smtp_pass"));
        }
        this.jdbc.close();
        return smtp;
    }

    public String updateSmtp(String address, String from, String user, String pass) {
        Object[] args = new String[]{address, from, user, pass};
        String sql = "UPDATE smtp SET smtp_address = ? ,smtp_from=?,smtp_user=?,smtp_pass=?";
        int o = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (o > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Info> getAllInfoTpl() throws SQLException {
        ArrayList<Info> infoList = new ArrayList<Info>();
        ResultSet rs = null;
        Info info = null;
        String sql = "select t.* from info_tpl t";
        rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            info = new Info();
            info.setId(rs.getInt("info_tpl_id"));
            info.setName(rs.getString("info_tpl_name"));
            info.setTitle(rs.getString("info_tpl_title"));
            info.setContent(rs.getString("info_tpl_content"));
            infoList.add(info);
        }
        this.jdbc.close();
        return infoList;
    }

    public String updateInfoTpl(Integer id, String title, String content) {
        Object[] args = new Object[]{title, content, id};
        String sql = "UPDATE info_tpl SET info_tpl_title=?,info_tpl_content=? where info_tpl_id=?";
        int o = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (o > 0) {
            return "ok";
        }
        return "bad";
    }

    public Info getInfoTplById(Integer id) throws SQLException {
        String sql = "select t.* from info_tpl t where t.info_tpl_id=?";
        ResultSet rs = null;
        Info info = null;
        rs = this.jdbc.executeQuery(sql, id);
        if (rs.next()) {
            info = new Info();
            info.setId(rs.getInt("info_tpl_id"));
            info.setName(rs.getString("info_tpl_name"));
            info.setTitle(rs.getString("info_tpl_title"));
            info.setContent(rs.getString("info_tpl_content"));
        }
        this.jdbc.close();
        return info;
    }

    public String addModular(String name, String url, String order, String parent, String is_cms, String style) {
        String code = "{\"id\":1,\"text\":\"" + name + "\",\"url\":\"" + url + "\"}";
        Object[] args = new String[]{code, is_cms, parent, style, order};
        String sql = "insert into adminmod (adminmod_code,adminmod_is_cms,adminmod_parent,adminmod_style,adminmod_order) values(?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateModular(Integer id, String name, String url, String order) {
        String code = "{\"id\":1,\"text\":\"" + name + "\",\"url\":\"" + url + "\"}";
        Object[] args = new Object[]{code, order, id};
        String sql = "update adminmod SET adminmod_code=?,adminmod_order=? where adminmod_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Integer countMuneBuParent(Integer parent) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from adminmod where adminmod_parent=? ";
        rs = this.jdbc.executeQuery(sql, parent);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public String deleteModular(Integer id) {
        String sql = "DELETE FROM adminmod WHERE adminmod_id=?";
        int flag = this.jdbc.executeUpdate(sql, id);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Integer getNextId(String scheme, String table) throws SQLException {
        Object[] args = new String[]{scheme, table};
        int countid = 0;
        String sql = "SELECT auto_increment AS countid FROM information_schema.`TABLES` WHERE TABLE_SCHEMA=? AND TABLE_NAME=?";
        ResultSet rs = null;
        rs = this.jdbc.executeQuery(sql, args);
        if (rs.next()) {
            countid = rs.getInt("countid");
        }
        this.jdbc.close();
        return countid;
    }

    public Recept getReceptById(String id) throws SQLException {
        String sql = "select r.* from recept r where r.recept_id=?";
        ResultSet rs = null;
        Recept recept = null;
        rs = this.jdbc.executeQuery(sql, id);
        if (rs.next()) {
            recept = new Recept();
            recept.setId(rs.getInt("recept_id"));
            recept.setName(rs.getString("recept_name"));
            recept.setTitle(rs.getString("recept_title"));
            recept.setKeywords(rs.getString("recept_keywords"));
            recept.setDescript(rs.getString("recept_descript"));
            recept.setJspMod(rs.getString("recept_mod"));
            recept.setModUrl(rs.getString("recept_url"));
            recept.setData_mod(rs.getString("recept_data_mod"));
            recept.setData_modcode(rs.getString("recept_data_modcode"));
            recept.setParent(rs.getInt("recept_parent"));
            recept.setAddress(rs.getString("recept_addr"));
            recept.setOrder(rs.getInt("recept_order"));
            recept.setIs_display(rs.getString("recept_is_display"));
            recept.setIs_self(rs.getInt("recept_is_self"));
        }
        this.jdbc.close();
        return recept;
    }

    public String addRecept(String name, String title, String keywords, String descript, String data_mod, String data_modcode, String parent, String addr, String url, String mod, String order, String is_display, String is_self) {
        Object[] args = new String[]{name, title, keywords, descript, data_mod, data_modcode, parent, addr, url, mod, order, is_display, is_self};
        String sql = "insert into recept (recept_name,recept_title,recept_keywords,recept_descript,recept_data_mod,recept_data_modcode,recept_parent,recept_addr,recept_url,recept_mod,recept_order,recept_is_display,recept_is_self) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateRecept(String id, String name, String title, String keywords, String descript, String data_mod, String data_modcode, String parent, String addr, String url, String mod, String order, String is_display, String is_self) {
        Object[] args = new Object[]{name, title, keywords, descript, data_mod, data_modcode, parent, addr, url, mod, order, is_display, is_self, id};
        String sql = "update recept SET recept_name=?,recept_title=?,recept_keywords=?,recept_descript=?,recept_data_mod=?,recept_data_modcode=?,recept_parent=?,recept_addr=?,recept_url=?,recept_mod=?,recept_order=?,recept_is_display=?,recept_is_self=? where recept_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteRecept(Integer id) {
        String sql = "DELETE FROM recept WHERE recept_id=?";
        int flag = this.jdbc.executeUpdate(sql, id);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String addUser(String username, String pass, String md5, String name, String tel, String email, String userflag, String userType) {
        Object[] args = new String[]{username, pass, md5, name, tel, email, userflag, userType};
        String sql = "insert into user (user_username,user_pass,user_pass_md5,user_name,user_tel,user_email,user_flag,user_type) values(?,?,?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String updateUser(String userflag, String userType, String id) {
        Object[] args = new Object[]{userflag, userType, id};
        String sql = "update user SET user_flag=?,user_type=? where user_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<User> getAllUser(Integer pageNo, Integer pageSize) throws SQLException {
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        String sql = "select u.*,ut.* from user u,user_type ut where u.user_type=ut.user_type_id order by u.user_id desc limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql);
        ArrayList<User> userList = new ArrayList<User>();
        User user = null;
        while (rs.next()) {
            user = new User();
            user.setId(rs.getInt("user_id"));
            user.setUsername(rs.getString("user_username"));
            user.setPass(rs.getString("user_pass"));
            user.setMd5(rs.getString("user_pass_md5"));
            user.setTel(rs.getString("user_tel"));
            user.setEmail(rs.getString("user_email"));
            user.setType(rs.getString("user_type"));
            user.setTypeName(rs.getString("user_type_name"));
            user.setName(rs.getString("user_name"));
            user.setFlag(rs.getString("user_flag"));
            user.setFlagName(rs.getString("user_flag"));
            userList.add(user);
        }
        this.jdbc.close();
        return userList;
    }

    public boolean getUserByTelAndUsernameAndEmail(String tel, String username, String email) throws SQLException {
        Object[] args = new String[]{tel, username, email};
        ResultSet rs = null;
        String sql = "select u.* from user u where u.user_tel=? or u.user_username=? or u.user_email=? ";
        rs = this.jdbc.executeQuery(sql, args);
        return rs.next();
    }

    public Integer getUserCount() throws SQLException {
        Integer resultCount = 0;
        String sql = "select COUNT(*) AS rowcount from user";
        ResultSet rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public User getUserById(Integer id) throws SQLException {
        ResultSet rs = null;
        String sql = "select u.*,ut.* from user u,user_type ut where u.user_id=? and u.user_type=ut.user_type_id";
        rs = this.jdbc.executeQuery(sql, id);
        User user = null;
        if (rs.next()) {
            user = new User();
            user.setId(rs.getInt("user_id"));
            user.setUsername(rs.getString("user_username"));
            user.setPass(rs.getString("user_pass"));
            user.setMd5(rs.getString("user_pass_md5"));
            user.setTel(rs.getString("user_tel"));
            user.setEmail(rs.getString("user_email"));
            user.setType(rs.getString("user_type"));
            user.setTypeName(rs.getString("user_type_name"));
            user.setName(rs.getString("user_name"));
            user.setFlag(rs.getString("user_flag"));
        }
        this.jdbc.close();
        return user;
    }

    public String addUserType(String name, String plus) {
        Object[] args = new String[]{name, plus};
        String sql = "insert into user_type (user_type_name,user_type_plu) values(?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<UserType> getUserType() throws SQLException {
        ResultSet rs = null;
        String sql = "select u.* from user_type u order by u.user_type_id desc";
        rs = this.jdbc.executeQuery(sql);
        ArrayList<UserType> typeList = new ArrayList<UserType>();
        UserType type = null;
        while (rs.next()) {
            type = new UserType();
            type.setId(rs.getInt("user_type_id"));
            type.setName(rs.getString("user_type_name"));
            type.setPlu(rs.getString("user_type_plu"));
            typeList.add(type);
        }
        this.jdbc.close();
        return typeList;
    }

    public UserType getUserType(String id) throws SQLException {
        ResultSet rs = null;
        String sql = "select u.* from user_type u where u.user_type_id=?";
        rs = this.jdbc.executeQuery(sql, id);
        UserType type = null;
        if (rs.next()) {
            type = new UserType();
            type.setId(rs.getInt("user_type_id"));
            type.setName(rs.getString("user_type_name"));
            type.setPlu(rs.getString("user_type_plu"));
        }
        this.jdbc.close();
        return type;
    }

    public String updateUserType(String id, String name, String plu) {
        Object[] args = new Object[]{name, plu, id};
        String sql = "update user_type SET user_type_name=?,user_type_plu=? where user_type_id=?";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public String deleteUserType(String ids) {
        String sql = "delete from user_type where user_type_id in (?)";
        int flag = this.jdbc.executeUpdate(sql, ids);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public Integer getMaxOrderForCms(Integer mod_id) throws SQLException {
        Integer resultCount = 0;
        String sql = "select max(cms_order) as order_id from cms where cms_admin_mod=?";
        ResultSet rs = this.jdbc.executeQuery(sql, mod_id);
        if (rs.next()) {
            resultCount = rs.getInt("order_id");
        }
        this.jdbc.close();
        return resultCount;
    }

    public Integer getMaxOrderForMod(Integer parent_id) throws SQLException {
        Integer resultCount = 0;
        String sql = "select max(adminmod_order) as order_id from adminmod where adminmod_parent=?";
        ResultSet rs = this.jdbc.executeQuery(sql, parent_id);
        if (rs.next()) {
            resultCount = rs.getInt("order_id");
        }
        this.jdbc.close();
        return resultCount;
    }

    public Integer getMaxOrderForRecept(Integer parent_id) throws SQLException {
        Integer resultCount = 0;
        String sql = "select max(recept_order) as order_id from recept where recept_parent=?";
        ResultSet rs = this.jdbc.executeQuery(sql, parent_id);
        if (rs.next()) {
            resultCount = rs.getInt("order_id");
        }
        this.jdbc.close();
        return resultCount;
    }
}

