/*
 * Decompiled with CFR 0.152.
 */
package com.weishang.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.weishang.pojo.AdminMod;
import com.weishang.pojo.Cms;
import com.weishang.pojo.CmsType;
import com.weishang.pojo.ColumnOrder;
import com.weishang.pojo.Comment;
import com.weishang.pojo.Cooperation;
import com.weishang.pojo.Net;
import com.weishang.pojo.Recept;
import com.weishang.pojo.Slide;
import com.weishang.pojo.Template;
import com.weishang.tool.GetUrlJson;
import com.weishang.tool.JdbcConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UserService {
    JdbcConnection jdbc = new JdbcConnection();

    public Net getNet() throws SQLException {
        Net net = new Net();
        String sql = "select n.* from net n";
        ResultSet rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            net.setId(rs.getInt("net_id"));
            net.setTitle(rs.getString("net_title"));
            net.setDescript(rs.getString("net_descript"));
            net.setKeywords(rs.getString("net_keywords"));
            net.setCopyright(rs.getString("net_copyright"));
            net.setCompany(rs.getString("net_company"));
            net.setInfo(rs.getString("net_info"));
            net.setLogo(rs.getString("net_logo"));
            net.setTel(rs.getString("net_tel"));
        }
        this.jdbc.close();
        return net;
    }

    public String saveCustomer(String type, String name, String person, String tel, String qq, String product, String admin, String time, String suorce) {
        Object[] args = new Object[]{type, name, person, tel, qq, product, admin, time, suorce};
        String sql = "insert into customer (customer_type,customer_name,customer_person,customer_tel,customer_qq,customer_product,customer_add_admin,customer_time2,customer_suorce) values(?,?,?,?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Cooperation> getCooperation(Integer tid, Integer pageNo, Integer pageSize) throws SQLException {
        ArrayList<Cooperation> userList = new ArrayList<Cooperation>();
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        String sql = "select c.* from cooperation c where c.case_type=? order by c.case_order desc limit " + offset + "," + sn;
        rs = this.jdbc.executeQuery(sql, tid);
        Cooperation co = null;
        while (rs.next()) {
            co = new Cooperation(rs.getInt("case_id"), rs.getString("case_name"), rs.getString("case_url"), rs.getString("case_img"));
            userList.add(co);
        }
        this.jdbc.close();
        return userList;
    }

    public List<Cms> getCmsByPage(Integer pageNo, Integer pageSize, String tid, Integer flag) throws SQLException {
        ArrayList<Cms> cmsList = new ArrayList<Cms>();
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        Cms cms = null;
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        String sql = "select c.* from cms c,adminmod am where c.cms_admin_mod=am.adminmod_id";
        if (tid != null && flag == null) {
            sql = String.valueOf(sql) + " and c.cms_admin_mod in (" + tid + ") order by c.cms_order desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql);
        } else if (tid != null && flag != null) {
            sql = String.valueOf(sql) + " and c.cms_admin_mod in (" + tid + ") and c.cms_flag=? order by c.cms_order desc limit " + offset + "," + sn;
            Object[] args = new Integer[]{flag};
            rs = this.jdbc.executeQuery(sql, args);
        } else if (tid == null && flag != null) {
            sql = String.valueOf(sql) + " and c.cms_flag=? order by c.cms_order desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql, flag);
        } else if (tid == null && flag == null) {
            sql = String.valueOf(sql) + " order by c.cms_order desc limit " + offset + "," + sn;
            rs = this.jdbc.executeQuery(sql);
        }
        while (rs.next()) {
            cms = new Cms();
            cms.setId(rs.getInt("cms_id"));
            cms.setName(rs.getString("cms_name"));
            cms.setSuroce(rs.getString("cms_suroce"));
            cms.setPerson(rs.getString("cms_peron"));
            cms.setContent(rs.getString("cms_content"));
            cms.setTime(rs.getString("cms_time"));
            cms.setKeyword(rs.getString("cms_keyword"));
            cms.setDescription(rs.getString("cms_description"));
            cms.setImg(rs.getString("cms_img"));
            cms.setSpare1(rs.getString("cms_spare1"));
            cms.setFlag(rs.getString("cms_flag"));
            cmsList.add(cms);
        }
        this.jdbc.close();
        return cmsList;
    }

    public Cms getCmsByAdminMod(Integer modid) throws SQLException {
        String sql = "select c.* from cms c where c.cms_admin_mod=?";
        Cms cms = new Cms();
        ResultSet rs = this.jdbc.executeQuery(sql, modid);
        if (rs.next()) {
            cms.setId(rs.getInt("cms_id"));
            cms.setName(rs.getString("cms_name"));
            cms.setSuroce(rs.getString("cms_suroce"));
            cms.setPerson(rs.getString("cms_peron"));
            cms.setContent(rs.getString("cms_content"));
            cms.setTime(rs.getString("cms_time"));
            cms.setKeyword(rs.getString("cms_keyword"));
            cms.setDescription(rs.getString("cms_description"));
            cms.setImg(rs.getString("cms_keyword"));
            cms.setSpare1(rs.getString("cms_spare1"));
            cms.setFlag(rs.getString("cms_flag"));
        }
        this.jdbc.close();
        return cms;
    }

    public CmsType getCmsType(Integer id) throws SQLException {
        String sql = "select ct.* from cms_type ct where ct.cms_type_id=?";
        CmsType ct = new CmsType();
        ResultSet rs = this.jdbc.executeQuery(sql, id);
        if (rs.next()) {
            ct.setId(rs.getInt("cms_type_id"));
            ct.setName(rs.getString("cms_type_name"));
            ct.setTitle(rs.getString("cms_type_title"));
            ct.setKeywords(rs.getString("cms_type_keyword"));
            ct.setDescription(rs.getString("cms_type_descript"));
        }
        this.jdbc.close();
        return ct;
    }

    public List<Slide> getSlide() throws SQLException {
        Slide slide = null;
        String sql = "select s.* from slide s order by s.slide_order desc";
        ResultSet rs = null;
        ArrayList<Slide> slideList = new ArrayList<Slide>();
        rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            slide = new Slide();
            slide.setId(rs.getInt("slide_id"));
            slide.setTitle(rs.getString("slide_title"));
            slide.setImg(rs.getString("slide_img"));
            slide.setUrl(rs.getString("slide_url"));
            slideList.add(slide);
        }
        this.jdbc.close();
        return slideList;
    }

    public List<CmsType> getCmsType() throws SQLException {
        CmsType slide = null;
        String sql = "select s.* from cms_type s where s.cms_type_id!=7 and s.cms_type_id!=8 order by s.cms_type_id desc";
        ResultSet rs = null;
        ArrayList<CmsType> slideList = new ArrayList<CmsType>();
        rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            slide = new CmsType();
            slide.setId(rs.getInt("cms_type_id"));
            slide.setName(rs.getString("cms_type_name"));
            slideList.add(slide);
        }
        this.jdbc.close();
        return slideList;
    }

    public List<Cms> getCmsList(Integer pageNo, Integer pageSize) throws SQLException {
        ArrayList<Cms> cmsList = new ArrayList<Cms>();
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        Cms cms = null;
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        String sql = "select c.*,ct.* from cms c,cms_type ct where c.cms_type_type=ct.cms_type_id";
        sql = String.valueOf(sql) + " and c.cms_flag=2 order by c.cms_order desc limit " + offset + "," + sn;
        rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            cms = new Cms();
            cms.setId(rs.getInt("cms_id"));
            cms.setName(rs.getString("cms_name"));
            cms.setSuroce(rs.getString("cms_suroce"));
            cms.setPerson(rs.getString("cms_peron"));
            cms.setContent(rs.getString("cms_content"));
            cms.setTime(rs.getString("cms_time"));
            cms.setKeyword(rs.getString("cms_keyword"));
            cms.setDescription(rs.getString("cms_description"));
            cms.setImg(rs.getString("cms_img"));
            cmsList.add(cms);
        }
        this.jdbc.close();
        return cmsList;
    }

    public ColumnOrder getColumn(Integer id) throws SQLException {
        String sql = "select co.* from column_order co where co.column_order_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, id);
        ColumnOrder co = new ColumnOrder();
        if (rs.next()) {
            co.setId(rs.getInt("column_order_id"));
            co.setName(rs.getString("column_order_name"));
            co.setTitle(rs.getString("column_order_title"));
            co.setKeywords(rs.getString("column_order_keywords"));
            co.setDescription(rs.getString("column_order_descript"));
        }
        this.jdbc.close();
        return co;
    }

    public List<Cms> getAllCmsList(Integer pageNo, Integer pageSize) throws SQLException {
        ArrayList<Cms> cmsList = new ArrayList<Cms>();
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        Cms cms = null;
        int offset = (pageNo - 1) * pageSize;
        int sn = offset + pageSize;
        String sql = "select c.*,ct.* from cms c,cms_type ct where c.cms_type_type=ct.cms_type_id";
        sql = String.valueOf(sql) + " and c.cms_type_type!=7 order by c.cms_order desc limit " + offset + "," + sn;
        rs = this.jdbc.executeQuery(sql);
        while (rs.next()) {
            cms = new Cms();
            cms.setId(rs.getInt("cms_id"));
            cms.setName(rs.getString("cms_name"));
            cms.setSuroce(rs.getString("cms_suroce"));
            cms.setPerson(rs.getString("cms_peron"));
            cms.setContent(rs.getString("cms_content"));
            cms.setTime(rs.getString("cms_time"));
            cms.setKeyword(rs.getString("cms_keyword"));
            cms.setDescription(rs.getString("cms_description"));
            cms.setImg(rs.getString("cms_img"));
            cmsList.add(cms);
        }
        this.jdbc.close();
        return cmsList;
    }

    public List<Recept> getRecept(Integer addr, String host) throws SQLException {
        String sql = "select r.* from recept r where r.recept_addr=? and r.recept_is_display=1 order by r.recept_order desc";
        ResultSet rs = null;
        Recept recept = null;
        rs = this.jdbc.executeQuery(sql, addr);
        ArrayList<Recept> receptList = new ArrayList<Recept>();
        while (rs.next()) {
            recept = new Recept();
            recept.setId(rs.getInt("recept_id"));
            recept.setName(rs.getString("recept_name"));
            recept.setTitle(rs.getString("recept_title"));
            recept.setKeywords(rs.getString("recept_keywords"));
            recept.setDescript(rs.getString("recept_descript"));
            recept.setJspMod(rs.getString("recept_mod"));
            Integer is_self = rs.getInt("recept_is_self");
            GetUrlJson g = new GetUrlJson();
            String flag = g.getUrlFlag(host);
            if (is_self.equals(1)) {
                String selfUrl = rs.getString("recept_url");
                Integer id = rs.getInt("recept_id");
                if (flag.equals("1")) {
                    recept.setModUrl(String.valueOf(selfUrl) + "/" + id + ".html");
                } else if (flag.equals("2")) {
                    recept.setModUrl("recept?action=" + selfUrl + "&menuId=" + id);
                }
            } else if (is_self.equals(2)) {
                Integer id = rs.getInt("recept_id");
                if (flag.equals("1")) {
                    recept.setModUrl("auto/" + id + ".html");
                } else if (flag.equals("2")) {
                    recept.setModUrl("recept?action=auto&menuId=" + id);
                }
            }
            recept.setData_mod(rs.getString("recept_data_mod"));
            recept.setData_modcode(rs.getString("recept_data_modcode"));
            recept.setParent(rs.getInt("recept_parent"));
            recept.setAddress(rs.getString("recept_addr"));
            recept.setOrder(rs.getInt("recept_order"));
            recept.setIs_display(rs.getString("recept_is_display"));
            recept.setIs_self(rs.getInt("recept_is_self"));
            receptList.add(recept);
        }
        this.jdbc.close();
        return receptList;
    }

    public Recept getReceptById(String id) throws SQLException {
        String sql = "select r.* from recept r where r.recept_id=?";
        ResultSet rs = null;
        Recept recept = null;
        rs = this.jdbc.executeQuery(sql, id);
        if (rs.next()) {
            recept = new Recept();
            recept.setId(rs.getInt("recept_id"));
            recept.setName(rs.getString("recept_name"));
            recept.setTitle(rs.getString("recept_title"));
            recept.setKeywords(rs.getString("recept_keywords"));
            recept.setDescript(rs.getString("recept_descript"));
            recept.setJspMod(rs.getString("recept_mod"));
            recept.setModUrl(rs.getString("recept_url"));
            recept.setData_mod(rs.getString("recept_data_mod"));
            recept.setData_modcode(rs.getString("recept_data_modcode"));
            recept.setParent(rs.getInt("recept_parent"));
            recept.setAddress(rs.getString("recept_addr"));
            recept.setOrder(rs.getInt("recept_order"));
            recept.setIs_display(rs.getString("recept_is_display"));
            recept.setIs_self(rs.getInt("recept_is_self"));
        }
        this.jdbc.close();
        return recept;
    }

    public List<Recept> getReceptByParent(Integer rid, String host) throws SQLException {
        String sql = "select r.* from recept r where r.recept_parent=? and r.recept_is_display=1 order by r.recept_order desc";
        ResultSet rs = null;
        Recept recept = null;
        rs = this.jdbc.executeQuery(sql, rid);
        ArrayList<Recept> receptList = new ArrayList<Recept>();
        while (rs.next()) {
            recept = new Recept();
            recept.setId(rs.getInt("recept_id"));
            recept.setName(rs.getString("recept_name"));
            recept.setTitle(rs.getString("recept_title"));
            recept.setKeywords(rs.getString("recept_keywords"));
            recept.setDescript(rs.getString("recept_descript"));
            recept.setJspMod(rs.getString("recept_mod"));
            Integer is_self = rs.getInt("recept_is_self");
            GetUrlJson g = new GetUrlJson();
            String flag = g.getUrlFlag(host);
            if (is_self.equals(1)) {
                String selfUrl = rs.getString("recept_url");
                Integer id = rs.getInt("recept_id");
                if (flag.equals("1")) {
                    recept.setModUrl(String.valueOf(selfUrl) + "/" + id + ".html");
                } else if (flag.equals("2")) {
                    recept.setModUrl("recept?action=" + selfUrl + "&menuId=" + id);
                }
            } else if (is_self.equals(2)) {
                Integer id = rs.getInt("recept_id");
                if (flag.equals("1")) {
                    recept.setModUrl("auto/" + id + ".html");
                } else if (flag.equals("2")) {
                    recept.setModUrl("recept?action=auto&menuId=" + id);
                }
            }
            recept.setData_mod(rs.getString("recept_data_mod"));
            recept.setData_modcode(rs.getString("recept_data_modcode"));
            recept.setParent(rs.getInt("recept_parent"));
            recept.setAddress(rs.getString("recept_addr"));
            recept.setOrder(rs.getInt("recept_order"));
            recept.setIs_display(rs.getString("recept_is_display"));
            recept.setIs_self(rs.getInt("recept_is_self"));
            receptList.add(recept);
        }
        this.jdbc.close();
        return receptList;
    }

    public AdminMod getModById(String id) throws SQLException {
        String sql = "select am.* from adminmod am where am.adminmod_id=?";
        ResultSet rs = this.jdbc.executeQuery(sql, id);
        AdminMod mod = null;
        while (rs.next()) {
            Integer modid = rs.getInt("adminmod_id");
            String code = rs.getString("adminmod_code");
            String css = rs.getString("adminmod_css");
            Integer parent = rs.getInt("adminmod_parent");
            JSONObject obj = (JSONObject)JSON.parse((String)code);
            String title = obj.get((Object)"text").toString();
            String url = obj.get((Object)"url").toString();
            Integer is_cms = rs.getInt("adminmod_is_cms");
            Integer style = rs.getInt("adminmod_style");
            Integer order = rs.getInt("adminmod_order");
            mod = new AdminMod(modid, title, css, parent, url, is_cms, style, code, order);
        }
        this.jdbc.close();
        return mod;
    }

    public List<Cms> getCmsByPage(Integer pageNo, Integer pageSize, String tid) throws SQLException {
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        ArrayList<Cms> cmsList = new ArrayList<Cms>();
        String sql = "select c.*,am.* from cms c,adminmod am where c.cms_admin_mod=am.adminmod_id and c.cms_admin_mod in (" + tid + ") order by c.cms_flag desc,c.cms_order desc limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql);
        Cms cms = null;
        while (rs.next()) {
            cms = new Cms();
            cms.setId(rs.getInt("cms_id"));
            cms.setName(rs.getString("cms_name"));
            cms.setStyle(rs.getString("cms_style"));
            cms.setSuroce(rs.getString("cms_suroce"));
            cms.setPerson(rs.getString("cms_peron"));
            cms.setContent(rs.getString("cms_content"));
            cms.setTime(rs.getString("cms_time"));
            cms.setMod(rs.getInt("adminmod_id"));
            String code = rs.getString("adminmod_code");
            JSONObject obj = (JSONObject)JSON.parse((String)code);
            String title = obj.get((Object)"text").toString();
            cms.setModName(title);
            cms.setFlag(rs.getString("cms_flag"));
            cms.setOrder(rs.getInt("cms_order"));
            cms.setImg(rs.getString("cms_img"));
            cms.setDescription(rs.getString("cms_description"));
            cms.setKeyword(rs.getString("cms_keyword"));
            cmsList.add(cms);
        }
        this.jdbc.close();
        return cmsList;
    }

    public Integer countCmsByMod(String tid) throws SQLException {
        int resultCount = 0;
        ResultSet rs = null;
        String sql = "select COUNT(*) AS rowcount from cms c,adminmod am where c.cms_admin_mod=am.adminmod_id and c.cms_admin_mod in (" + tid + ")";
        rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            resultCount = rs.getInt("rowcount");
        }
        this.jdbc.close();
        return resultCount;
    }

    public Cms getCmsByModId(Integer id) throws SQLException {
        ResultSet rs = null;
        String sql = "select c.* from cms c where c.cms_admin_mod=? ";
        rs = this.jdbc.executeQuery(sql, id);
        Cms cms = null;
        if (rs.next()) {
            cms = new Cms();
            cms.setId(rs.getInt("cms_id"));
            cms.setName(rs.getString("cms_name"));
            cms.setStyle(rs.getString("cms_style"));
            cms.setSuroce(rs.getString("cms_suroce"));
            cms.setPerson(rs.getString("cms_peron"));
            cms.setContent(rs.getString("cms_content"));
            cms.setTime(rs.getString("cms_time"));
            cms.setFlag(rs.getString("cms_flag"));
            cms.setOrder(rs.getInt("cms_order"));
            cms.setImg(rs.getString("cms_img"));
            cms.setDescription(rs.getString("cms_description"));
            cms.setKeyword(rs.getString("cms_keyword"));
        }
        this.jdbc.close();
        return cms;
    }

    public boolean getAuthorizationNet(String www) throws SQLException {
        ResultSet rs = null;
        String sql = "select a.authorization_id from authorization a where a.authorization_www=?";
        rs = this.jdbc.executeQuery(sql, www);
        if (rs.next()) {
            this.jdbc.close();
            return true;
        }
        this.jdbc.close();
        return false;
    }

    public Template getTemplate() throws SQLException {
        Template tpl = null;
        ResultSet rs = null;
        String sql = "select t.* from tpl t where t.tpl_flag=1";
        rs = this.jdbc.executeQuery(sql);
        if (rs.next()) {
            tpl = new Template();
            tpl.setId(rs.getInt("tpl_id"));
            tpl.setFlag(rs.getInt("tpl_flag"));
            tpl.setFolder(rs.getString("tpl_folder"));
            tpl.setName(rs.getString("tpl_name"));
        }
        this.jdbc.close();
        return tpl;
    }

    public String addComment(String title, String date, String content, String user, String cms, String mode, String grade, String grade_img) {
        Object[] args = new String[]{date, title, content, user, cms, mode, grade, grade_img};
        String sql = "insert into comment (comment_date,comment_tile,comment_content,comment_user,comment_cms,comment_mode,comment_grade,comment_grade_img) values(?,?,?,?,?,?,?,?)";
        int flag = this.jdbc.executeUpdate(sql, args);
        this.jdbc.close();
        if (flag > 0) {
            return "ok";
        }
        return "bad";
    }

    public List<Comment> getCommentByCmsId(Integer pageNo, Integer pageSize, String id, String mid) throws SQLException {
        Object[] args = new String[]{id, mid};
        ResultSet rs = null;
        if (pageNo < 1) {
            pageNo = 1;
        }
        int offset = (pageNo - 1) * pageSize;
        ArrayList<Comment> commentList = new ArrayList<Comment>();
        String sql = "select c.* from comment c where c.comment_cms=? and c.comment_mode=? order by c.comment_id desc limit " + offset + "," + pageSize;
        rs = this.jdbc.executeQuery(sql, args);
        Comment comment = null;
        while (rs.next()) {
            comment = new Comment();
            comment.setId(rs.getString("comment_id"));
            comment.setDate(rs.getString("comment_date"));
            comment.setTitle(rs.getString("comment_tile"));
            comment.setContent(rs.getString("comment_content"));
            comment.setUser(rs.getString("comment_user"));
            comment.setCms(rs.getString("comment_cms"));
            comment.setMode(rs.getString("comment_mode"));
            comment.setGrade(rs.getString("comment_grade"));
            comment.setGrade_img(rs.getString("comment_grade_img"));
            commentList.add(comment);
        }
        this.jdbc.close();
        return commentList;
    }

    public Comment getCommentById(String id) throws SQLException {
        String sql = "select c.* from comment c where c.comment_id=?";
        ResultSet rs = null;
        Comment comment = null;
        rs = this.jdbc.executeQuery(sql, id);
        if (rs.next()) {
            comment = new Comment();
            comment.setId(rs.getString("comment_id"));
            comment.setDate(rs.getString("comment_date"));
            comment.setTitle(rs.getString("comment_tile"));
            comment.setContent(rs.getString("comment_content"));
            comment.setUser(rs.getString("comment_user"));
            comment.setCms(rs.getString("comment_cms"));
            comment.setMode(rs.getString("comment_mode"));
            comment.setGrade(rs.getString("comment_grade"));
            comment.setGrade_img(rs.getString("comment_grade_img"));
        }
        return comment;
    }

    public Cms getUpOrNext(Integer id, Integer mode, Integer flag) throws SQLException {
        ResultSet rs = null;
        String sql = "";
        if (flag.equals(1)) {
            sql = "select c.* from cms c where c.cms_id = (select m.cms_id from  cms m where m.cms_id <? and m.cms_admin_mod=? order by m.cms_id desc limit 0,1) and c.cms_admin_mod=? ";
        } else if (flag.equals(2)) {
            sql = "select c.* from cms c where c.cms_id = (select m.cms_id from  cms m where m.cms_id >? and m.cms_admin_mod=? order by m.cms_id asc limit 0,1) and c.cms_admin_mod=? ";
        }
        Object[] args = new Integer[]{id, mode, mode};
        rs = this.jdbc.executeQuery(sql, args);
        Cms cms = null;
        if (rs.next()) {
            cms = new Cms();
            cms.setId(rs.getInt("cms_id"));
            cms.setName(rs.getString("cms_name"));
            cms.setStyle(rs.getString("cms_style"));
            cms.setSuroce(rs.getString("cms_suroce"));
            cms.setPerson(rs.getString("cms_peron"));
            cms.setContent(rs.getString("cms_content"));
            cms.setTime(rs.getString("cms_time"));
            cms.setFlag(rs.getString("cms_flag"));
            cms.setOrder(rs.getInt("cms_order"));
            cms.setImg(rs.getString("cms_img"));
            cms.setDescription(rs.getString("cms_description"));
            cms.setKeyword(rs.getString("cms_keyword"));
            cms.setMod(rs.getInt("cms_admin_mod"));
        }
        this.jdbc.close();
        return cms;
    }
}

