/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WriterOutputStream
extends OutputStream {
    @Nonnull
    private final Writer writer;
    @Nullable
    private final String encoding;
    @Nonnull
    private final byte[] buffer = new byte[1];

    public WriterOutputStream(@Nonnull Writer writer) {
        this(writer, null);
    }

    public WriterOutputStream(@Nonnull Writer writer, @Nullable String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.encoding == null) {
            this.writer.write(new String(b));
        } else {
            this.writer.write(new String(b, this.encoding));
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.encoding == null) {
            this.writer.write(new String(b, off, len));
        } else {
            this.writer.write(new String(b, off, len, this.encoding));
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer[0] = (byte)b;
        this.write(this.buffer);
    }
}

