/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoft.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReaderInputStream
extends InputStream {
    @Nonnull
    private final Reader in;
    @Nonnull
    private final String encoding;
    @Nullable
    private byte[] slack;
    private int begin;

    public ReaderInputStream(@Nonnull Reader in) {
        this(in, null);
    }

    public ReaderInputStream(@Nonnull Reader in, @Nonnull @Nullable String encoding) {
        this.in = in;
        this.encoding = encoding == null ? System.getProperty("file.encoding") : encoding;
    }

    @Override
    public int read() throws IOException {
        int result;
        if (this.slack != null && this.begin < this.slack.length) {
            result = this.slack[this.begin];
            if (++this.begin == this.slack.length) {
                this.slack = null;
            }
        } else {
            byte[] buf = new byte[1];
            if (this.read(buf, 0, 1) <= 0) {
                result = -1;
            }
            result = buf[0];
        }
        if (result < -1) {
            result = (byte)(result + 256);
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (this.slack == null) {
            char[] buf = new char[len];
            int n = this.in.read(buf);
            if (n == -1) {
                return -1;
            }
            if (n <= 0) continue;
            this.slack = new String(buf, 0, n).getBytes(this.encoding);
            this.begin = 0;
        }
        if (len > this.slack.length - this.begin) {
            len = this.slack.length - this.begin;
        }
        System.arraycopy(this.slack, this.begin, b, off, len);
        if ((this.begin += len) >= this.slack.length) {
            this.slack = null;
        }
        return len;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.in.mark(readlimit);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.slack != null) {
            return this.slack.length - this.begin;
        }
        if (this.in.ready()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.slack = null;
        this.in.reset();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.slack = null;
    }
}

