enum SCMBoatPos
{
	SCMBP_Invalid,
	SCMBP_Front,
	SCMBP_Pos1,
	SCMBP_Pos2,
	SCMBP_Pos3,
	SCMBP_Pos4,
	SCMBP_Pos5,
	SCMBP_Pos6,
	SCMBP_Pos7,
	SCMBP_Pos8,
	SCMBP_Pos9,
	SCMBP_Pos10,
	SCMBP_Pos11,
	SCMBP_Pos12,
	SCMBP_Pos13,
	SCMBP_Pos14,
	SCMBP_Pos15,
	SCMBP_Pos16,
	SCMBP_Pos17,
	SCMBP_Pos18,
	SCMBP_Pos19,
	SCMBP_Pos20
}

class SCMBoatEntry
{
	
	private var boat : W3Boat;
	private var manager : SCMBoatManager;
	
	private var taken : array<bool>;
	private var takenSize : int;
	
	public function GetBoat() : W3Boat
	{
		return boat;
	}

	public function Init(boat : W3Boat, manager : SCMBoatManager)
	{
		var i : int;
		this.boat = boat;
		this.manager = manager;
		
		for(i = 21-1; i >= 0; i-=1)
		{
			taken.PushBack(false);
		}
		
		takenSize = taken.Size();
	}
	
	public function GetFreePosition(optional register : bool, optional ignorePassenger : bool) : SCMBoatPos
	{
		var i : int;
		i = 0;
		
		if(ignorePassenger) i = 1;
		
		for(; i < takenSize; i+=1)
		{
			if(!taken[i])
			{
				if(register) taken[i] = true;
				return (SCMBoatPos)(i+1);
			}
		}
		
		return SCMBP_Invalid;
	}
	
	public function TakePosition(pos : SCMBoatPos)
	{
		if(pos > 0 && pos <= takenSize)
		{
			taken[pos-1] = true;
		}
	}
	
	public function FreePosition(pos : SCMBoatPos)
	{
		if(pos > 0 && pos <= takenSize)
		{
			taken[pos-1] = false;
			DestroyIfFree();
		}
	}
	
	private function DestroyIfFree()
	{
		var i : int;
		
		for(i = 0; i < takenSize; i+=1)
		{
			if(taken[i])
			{
				return;
			}
		}
		
		manager.DestroyInstance(this);
	}
	
	public function GetOffsetFor(boatPos : SCMBoatPos, out pos : Vector, out rot : EulerAngles)
	{
		var x,y,z : float;
		var dontRandomize : bool;
		x = 0.6;
		y = 0.5;
		z = 0.24;
		
		rot = EulerAngles(0, 0, 0);
		
		switch(boatPos)
		{
			case SCMBP_Front: pos = Vector(-0.15, 2.8, 0.39); rot = EulerAngles(0, 180, 0); dontRandomize = true; break;
			case SCMBP_Pos1: pos = Vector(-x*0.6, 1.8, z); break;
			case SCMBP_Pos2: pos = Vector( x*0.6, 1.8, z); break;
			
			case SCMBP_Pos3: pos = Vector(-x,  y, z); break;
			case SCMBP_Pos4: pos = Vector( 0,  y, z); break;
			case SCMBP_Pos5: pos = Vector( x,  y, z); break;
			
			case SCMBP_Pos6: pos = Vector(-x,  0, z); break;
			case SCMBP_Pos7: pos = Vector( 0,  0, z); break;
			case SCMBP_Pos8: pos = Vector( x,  0, z); break;
			
			case SCMBP_Pos9: pos = Vector(-x, -y, z); break;
			case SCMBP_Pos10: pos = Vector( 0, -y, z); break;
			case SCMBP_Pos11: pos = Vector( x, -y, z); break;
			
			case SCMBP_Pos12: pos = Vector(-x, -2*y, z); break;
			case SCMBP_Pos13: pos = Vector( 0, -2*y, z); break;
			case SCMBP_Pos14: pos = Vector( x, -2*y, z); break;
			
			case SCMBP_Pos15: pos = Vector(-x, -3*y, z); break;
			case SCMBP_Pos16: pos = Vector( 0, -3*y, z); break;
			case SCMBP_Pos17: pos = Vector( x, -3*y, z); break;
			
			case SCMBP_Pos18: pos = Vector(-x, -4*y, z); break;
			case SCMBP_Pos19: pos = Vector( 0, -4*y, z); break;
			case SCMBP_Pos20: pos = Vector( x, -4*y, z); break;
			case SCMBP_Pos20: pos = Vector( x, -4*y, z); break;
		
		}
		if(!dontRandomize)
		{
			pos.X += RandRange(100, -100)/1000.0;
			pos.Y += RandRange(100, -100)/1000.0;
			rot.Yaw = RandRange(20, -20);
		}
		
	}
	
	public function GetStartIdleStopAnimsFor(boatPos : SCMBoatPos, out start, idle, stop : name)
	{
		switch(boatPos)
		{
			case SCMBP_Front: start = 'boat_passenger_sit_start_back'; idle = 'boat_passenger_sit_idle'; stop = 'boat_passenger_sit_stop'; break;
			default: start = 'high_standing_determined_idle'; idle = 'high_standing_determined_idle'; stop = ''; break;
		}
	}
	
}

class SCMBoatManager
{
	var instances : array<SCMBoatEntry>;

	public function init()
	{}
	
	private function _CreateInstance(boat : W3Boat) : SCMBoatEntry
	{
		var instance : SCMBoatEntry;
		instance = new SCMBoatEntry in this;
		
		instance.Init(boat, this);
		
		instances.PushBack(instance);
		
		return instance;
	}
	
	public function DestroyInstance(boatEntry : SCMBoatEntry)
	{
		instances.Remove(boatEntry);
		
		delete boatEntry;
	}
	
	public function GetBoatEntry(boat : W3Boat) : SCMBoatEntry
	{
		var i : int;
		
		for(i = instances.Size()-1; i >= 0; i-=1)
		{
			if(instances[i].GetBoat() == boat)
			{
				return instances[i];
			}
		}
		
		return _CreateInstance(boat);
	}
	
}