local assets=
{
	Asset("ANIM", "anim/boomdart.zip"),
	Asset("IMAGE", "images/inventoryimages/boomdart.tex"),
    Asset("ATLAS", "images/inventoryimages/boomdart.xml"),
}

local function onhit(inst, attacker, target)
    SpawnPrefab("collapse_small").Transform:SetPosition(target.Transform:GetWorldPosition())
    SpawnPrefab("explode_small").Transform:SetPosition(target.Transform:GetWorldPosition())
    GetClock():DoLightningLighting()
    attacker.components.playercontroller:ShakeCamera(target, "FULL", 0.7, 0.02, .5, 40)

    local pos = Vector3(target.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 3)
    for k,v in pairs(ents) do
    if v ~= attacker and v ~= target and v.components.combat then 
       v.components.combat:GetAttacked(attacker, 50, nil, "boomdart")
    if v.components.combat then 
    if not attacker.components.leader:IsFollower(v) then
       v.components.combat:SuggestTarget(attacker)
       end
     end
   end
    if v == attacker then
    if v.components.combat then 
       v.components.combat:GetAttacked(inst, 25, nil, "boomdart")
    end    
  end
end

    inst:Remove()
end

local function onthrown(inst, data)
    --inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    inst.AnimState:PlayAnimation("onhit")
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("boomdart")
    anim:SetBuild("boomdart")
    anim:PlayAnimation("onfloor")
    inst.Transform:SetScale(2, 2, 2)
    
    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(50)
    inst.components.weapon:SetRange(12, 14)

    inst:AddComponent("equippable")
    inst.components.equippable.equipstack = true

    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(65)
    inst.components.projectile:SetOnHitFn(onhit)

    inst:ListenForEvent("onthrown", onthrown)

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname="images/inventoryimages/boomdart.xml"

    inst:AddComponent("stackable")

    return inst
end

return Prefab( "common/inventory/boomdart", fn, assets)