local assets=
{
	Asset("ANIM", "anim/revolver.zip"),
	Asset("ANIM", "anim/swap_revolver.zip"),
	Asset("IMAGE", "images/inventoryimages/revolver.tex"),
    Asset("ATLAS", "images/inventoryimages/revolver.xml"),
    Asset("IMAGE", "images/inventoryimages/bullet.tex"),
    Asset("ATLAS", "images/inventoryimages/bullet.xml"),
}

local prefabs =
{
	"impact",
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_revolver", "symbol0")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
	
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function onattack(inst, attacker, target)
    
	--
	local bullets = attacker.components.inventory:FindItem(function(item) return item.prefab=="bullet" end)
    --local ammo_loaded = inst.components.finiteuses:GetUses()
	--
	
	
	inst.SoundEmitter:PlaySound("dontstarve/creatures/eyeballturret/shotexplo")
    if attacker.components.inventory:Has("bullet", 1) then
       attacker.components.inventory:ConsumeByName("bullet", 1)
    end
    
    if math.random() <= 0.2 then
		if target.components.combat then 
			target.components.combat:GetAttacked(attacker, 20, nil, "revolver")
		end
		local pt = target:GetPosition()
		attacker:StartThread(function()
            for k = 1, 3 do
                --local blood = SpawnPrefab("splash")
                --blood.Transform:SetPosition(pt.x, 1.5, pt.z)
                --blood.AnimState:SetMultColour(255/255,0/255,0/255,1)
                --blood.Transform:SetScale(2, 2, 2)
                Sleep(.1)
            end
        end)
    end
	
end

local function itemtest(inst, item, slot)
    return item.prefab == "bullet" 
end

local slotpos = {}

for y = 0, .5 do
	--table.insert(slotpos, Vector3(-162, -y*75 + 114 ,0))
	table.insert(slotpos, Vector3(-162 -448, -y*75 + 85 ,0))
end

local function rfn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	
	inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
	
	inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("revolver")
    anim:SetBuild("revolver")
    anim:PlayAnimation("revolver")
    inst.Transform:SetScale(.8, .8, .8)
    
    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(30)
    inst.components.weapon:SetRange(10, 12)
    inst.components.weapon:SetOnAttack(onattack)
    inst.components.weapon:SetProjectile("fire_projectile")


    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname="images/inventoryimages/revolver.xml"
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    inst:DoPeriodicTask(.5, function()
		--local ammo_loaded = inst.components.finiteuses:GetUses()
		if inst.components.equippable.isequipped then
			local owner = inst.components.inventoryitem.owner
			if not owner.components.inventory:Has("bullet", 1) then
				if inst.components.weapon then
					inst:RemoveComponent("weapon")
				end
			else
				if not inst.components.weapon then
					inst:AddComponent("weapon")
					inst.components.weapon:SetDamage(30)
					inst.components.weapon:SetRange(10, 12)
					inst.components.weapon:SetOnAttack(onattack)
					inst.components.weapon:SetProjectile("fire_projectile")
				end
			end
		end
	end)

    return inst
end

local function OnIgniteFn(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_fuse_LP", "hiss")
    inst:DoTaskInTime(1.5, function() inst.Physics:SetMotorVelOverride(0,8,0) end)
end

local function OnExplodeFn(inst)
    local pos = Vector3(inst.Transform:GetWorldPosition())
    inst.SoundEmitter:KillSound("hiss")
    inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_explo")

    local explode = SpawnPrefab("explode_small")
    local pos = inst:GetPosition()
    explode.Transform:SetPosition(pos.x, pos.y, pos.z)

    --local explode = PlayFX(pos,"explode", "explode", "small")
    explode.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    explode.AnimState:SetLightOverride(1)
end

local function bfn(Sim)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
	
	inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
	
    inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("revolver")
    anim:SetBuild("revolver")
    anim:PlayAnimation("bullet")
    --inst.Transform:SetScale(2, 2, 2)
    
    inst:AddTag("sharp")
    inst:AddComponent("inspectable")

    inst:AddComponent("stackable")
    --*--inst.components.stackable.maxsize = 7

    MakeSmallBurnable(inst, 3+math.random()*3)
    MakeSmallPropagator(inst)
    
    inst:AddComponent("explosive")
    inst.components.explosive:SetOnExplodeFn(OnExplodeFn)
    --inst.components.explosive:SetOnIgniteFn(OnIgniteFn)
    inst.components.explosive.explosivedamage = 25
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname="images/inventoryimages/bullet.xml"

    return inst
end

return Prefab( "common/inventory/revolver", rfn, assets),Prefab( "common/inventory/bullet", bfn, assets)