﻿
$(document).ready(function() {
    onload();
});


function onload() {
    try{
        var yearlyPay = window.parent.getYearlyPay();
        yearlyPay = parseFloat(yearlyPay).toFixed(0);
	    $("#span_year_price").text(yearlyPay);
	    var rechargeURL = getRechargeURL_YEAR(yearlyPay);
	    $("#link_recharge_year").attr("href",rechargeURL);
    }catch(e){}
}


function getRechargeURL_YEAR(yearlyPay){
    var userInfo = window.parent.getUserInfo();
    var userID = userInfo[2];
    var payDomain = window.parent.getStrPayDomain();
    var productName = window.parent.getProductName();
    var rechargeURL = payDomain+"/Recharge.aspx";
    rechargeURL +="?uid="+encode64(userID);
    rechargeURL +="&prductName="+encode64(encodeURI(productName));
    rechargeURL +="&rechargeFrom=2&numList="+encode64(yearlyPay);
    return rechargeURL;
}


function yearlyRecharge(){
    setInterval("getAmountInfo()",1000);
}

function getAmountInfo(){
    var userInfo = window.parent.getUserInfo();
    var userID = userInfo[2];
	var payDomain = window.parent.getStrPayDomain();
    var url = payDomain+"/webService/payoff.asmx/getBalanceByUID_JS?callback=?"
    $.ajax({
                  url: url,
                  dataType:"jsonp",
                  data:{ "strUID": userID },
                  success:function(data){
                    if(data.msgCode=="1"){
                        var userAmount = data.data;  
                        userAmount = parseFloat(userAmount).toFixed(0);
                        var yearlyPay = window.parent.getYearlyPay();
                        yearlyPay = parseFloat(yearlyPay).toFixed(0);	
	                    if(userAmount-yearlyPay>=0){
	                        closePrompt();
	                        window.parent.ShowDiv("MyDiv_YearlyPay_Success", "fade_YearlyPay_Success", "iframe_YearlyPay_RechargeSuccess.html",220, 438);   
	                    }
                    }
                  }
               });
}


function closePrompt() {
    window.parent.CloseDiv('MyDiv_YearlyPay_Success', 'fade_YearlyPay_Success');
}