﻿//获取property中的字符串节点数据

function testType(strData) {
    var regx = /<Type[^>]*>[\s\S]*?<\/Type>/gi;
    var result = regx.test(strData);
    return result;
}

function testRange(strData) {
    var regx = /<Range[^>]*>[\s\S]*?<\/Range>/gi;
    var result = regx.test(strData);
    return result;
}

function testEquation(strData) {

    var regx = /<Equation[^>]*>[\s\S]*?<\/Equation>/gi;
    var result = regx.test(strData);
    return result;
}

function testFormat(strData) {
    var regx = /<Format[^>]*>[\s\S]*?<\/Format>/gi;
    var result = regx.test(strData);
    return result;
}

function testParamName(strData) {
    var regx = /<ParamName[^>]*>[\s\S]*?<\/ParamName>/gi;
    var result = regx.test(strData);
    return result;
}

function testRelation(strData) {
    var regx = /<Relation[^>]*>[\s\S]*?<\/Relation>/gi;
    var result = regx.test(strData);
    return result;
}

function testCondition(strData) {
    var regx = /<Condition[^>]*>[\s\S]*?<\/Condition>/gi;
    var result = regx.test(strData);
    return result;
}

function testRemarks(strData) {
    var regx = /<Remarks[^>]*>[\s\S]*?<\/Remarks>/gi;
    var result = regx.test(strData);
    return result;
}

function testRelationRemark(strData) {
    var regx = /<RelationRemark[^>]*>[\s\S]*?<\/RelationRemark>/gi;
    var result = regx.test(strData);
    return result;
}

function testRelationRange(strData) {
    var regx = /<RelationRange[^>]*>[\s\S]*?<\/RelationRange>/gi;
    var result = regx.test(strData);
    return result;
}

function testEquationRange(strData) {
    var regx = /<EquationRange[^>]*>[\s\S]*?<\/EquationRange>/gi;
    var result = regx.test(strData);
    return result;
}

function testEquationRemarks(strData) {
    var regx = /<EquationRemark[^>]*>[\s\S]*?<\/EquationRemark>/gi;
    var result = regx.test(strData);
    return result;
}


function testRound(strData) {
    var regx = /<Round[^>]*>[\s\S]*?<\/Round>/gi;
    var result = regx.test(strData);
    return result;
}

function testElseType(strData) {
    var regx = /<ElseType[^>]*>[\s\S]*?<\/ElseType>/gi;
    var result = regx.test(strData);
    return result;
}

function testElseRange(strData) {
    var regx = /<ElseRange[^>]*>[\s\S]*?<\/ElseRange>/gi;
    var result = regx.test(strData);
    return result;
}

function testElseEquation(strData) {
    var regx = /<ElseEquation[^>]*>[\s\S]*?<\/ElseEquation>/gi;
    var result = regx.test(strData);
    return result;
}

function testElseFormat(strData) {
    var regx = /<ElseFormat[^>]*>[\s\S]*?<\/ElseFormat>/gi;
    var result = regx.test(strData);
    return result;
}

function testElseRemarks(strData) {
    var regx = /<ElseRemarks[^>]*>[\s\S]*?<\/ElseRemarks>/gi;
    var result = regx.test(strData);
    return result;
}

function testElseValue(strData) {
    var regx = /<ElseValue[^>]*>[\s\S]*?<\/ElseValue>/gi;
    var result = regx.test(strData);
    return result;
}

function testElseParamName(strData) {
    var regx = /<ElseParamName[^>]*>[\s\S]*?<\/ElseParamName>/gi;
    var result = regx.test(strData);
    return result;
}

function testElseEquationRange(strData) {
    var regx = /<ElseEquationRange[^>]*>[\s\S]*?<\/ElseEquationRange>/gi;
    var result = regx.test(strData);
    return result;
}

function testElseEquationRemark(strData) {
    var regx = /<ElseEquationRemark[^>]*>[\s\S]*?<\/ElseEquationRemark>/gi;
    var result = regx.test(strData);
    return result;
}

function testElseRound(strData) {
    var regx = /<ElseRound[^>]*>[\s\S]*?<\/ElseRound>/gi;
    var result = regx.test(strData);
    return result;
}

function getType(strData) {
    //    var regx = /<Type[^>]*>[\s\S]*?<\/Type>/gi;

    var regx = /<Type>[^<>]*?<\/Type>/gi

    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(6, data.length - 7);
    }
    return "";
}

function getRange(strData) {
    var regx = /<Range[^>]*>[\s\S]*?<\/Range>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(7, data.length - 8);
    }
    return "";
}

function getEquation(strData) {
    var regx = /<Equation[^>]*>[\s\S]*?<\/Equation>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(10, data.length - 11);
    }
    return "";
}

function getFormat(strData) {
    var regx = /<Format[^>]*>[\s\S]*?<\/Format>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(8, data.length - 9);
    }
    return "";
}

function getParamName(strData) {
    var regx = /<ParamName[^>]*>[\s\S]*?<\/ParamName>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(11, data.length - 12);
    }
    return "";
}

function getRelation(strData) {
    var regx = /<Relation[^>]*>[\s\S]*?<\/Relation>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(10, data.length - 11);
    }
    return "";
}

function getCondition(strData) {
    var regx = /<Condition[^>]*>[\s\S]*?<\/Condition>/gi;
    var result = strData.match(regx);
    //    if (result != null) {
    //        var data = result[0];
    //        return data.substring(11, data.length - 12);
    //    }
    //    return "";
    return result;
}

function getRemarks(strData) {
    var regx = /<Remarks[^>]*>[\s\S]*?<\/Remarks>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(9, data.length - 10);
    }
    return "";
}

function getRelationRemark(strData) {
    var regx = /<RelationRemark[^>]*>[\s\S]*?<\/RelationRemark>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(16, data.length - 17);
    }
    return "";
}

function getRelationRange(strData) {
    var regx = /<RelationRange[^>]*>[\s\S]*?<\/RelationRange>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(15, data.length - 16);
    }
    return "";
}

function getEquationRange(strData) {
    var regx = /<EquationRange[^>]*>[\s\S]*?<\/EquationRange>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(15, data.length - 16);
    }
    return "";
}

function getEquationRemarks(strData) {
    var regx = /<EquationRemark[^>]*>[\s\S]*?<\/EquationRemark>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(16, data.length - 17);
    }
    return "";
}

function getTable(strData) {
    var regx = /<Table[^>]*>[\s\S]*?<\/Table>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(7, data.length - 8);
    }
    return "";
}

function getField(strData) {
    var regx = /<Field[^>]*>[\s\S]*?<\/Field>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(7, data.length - 8);
    }
    return "";
}

function getRelateField(strData) {
    var regx = /<RelateField[^>]*>[\s\S]*?<\/RelateField>/gi;
    var result = strData.match(regx);
    var condition = "";
    if (result != null) {
        for (var i = 0; i < result.length; i++) {
            var data = result[i];
            data = data.substring(13, data.length - 14);
            if (i == 0) {
                condition += " where ";
            }
            else {
                condition += " and "
            }
            condition += replaceFieldSQL(data);
        }
    }
    return condition;
}

function getRound(strData) {
    var regx = /<Round[^>]*>[\s\S]*?<\/Round>/gi;
    var result = strData.match(regx);
    if (result != null) {
        var data = result[0];
        return data.substring(7, data.length - 8);
    }
    return "";
}


//解析property中的字符串节点,并赋值

function setType(tempObj, property) {
    var type = getType(property)
    tempObj.type = type;
    if (type != "STRING_COMBO" && type != "") {
        tempObj.elsetype = 0;
    }
}

function setRange(tempObj, property) {
    var range = getRange(property);
    tempObj.range = range;
}

function setEquation(tempObj, property) {
    var equation = getEquation(property);
    equation = replaceField(equation);
    tempObj.value = getEval(equation);
}

function setFormat(tempObj, property) {
    var format = getFormat(property);
    tempObj.value = replaceField(format);
}

function setParamName(tempObj, property) {
    var name = getParamName(property);
    tempObj.paramName = name;
}

function setRelation(tempObj, property) {
    var relation = getRelation(property);
    var index = relation.indexOf("<");
    var strData = relation.substring(0, index);
    var value = getRelateValue(relation);
    strData = strData.replace("$", value);
    tempObj.value = strData;
}

function setRound(tempObj, property) {
    var name = getRound(property);
    var curValue = tempObj.value;
    var num = new Number(curValue);
    if (!isNaN(num)) {
        setRoundValue(tempObj, name);
    }
}

function setConditionList(tempObj, property) {
    var conditionList = getCondition(property);
    if (conditionList != null) {
        for (var i = 0; i < conditionList.length; i++) {
            var con = conditionList[i];
            var condition = con.substring(11, con.length - 12);
            setCondition(tempObj, condition);
        }
    }
}

function setCondition(tempObj, condition) {
    var objContion = {};
    objContion.ElseType = "";
    objContion.ElseRange = "";
    objContion.ElseRemarks = "";
    objContion.ElseParamName = "";
    objContion.ElseFormat = "";
    objContion.ElseEquationRemark = "";
    objContion.ElseEquationRange = "";
    objContion.ElseEquation = "";
    objContion.ElseValue = "";
    objContion.ElseRound = "";
    var strCon = splitCondition(condition, objContion);
    if (checkCondition(strCon, tempObj.value)) {
        if (objContion.ElseType != "") {
            setElseType(tempObj, objContion.ElseType);
        }
        if (objContion.ElseRange != "") {
            setElseRange(tempObj, objContion.ElseRange);
        }
        if (objContion.ElseRemarks != "") {
            setElseRemarks(tempObj, objContion.ElseRemarks);
        }
        if (objContion.ElseValue != "") {
            setElseValue(tempObj, objContion.ElseValue);
        }
        if (objContion.ElseParamName != "") {
            setElseParamName(tempObj, objContion.ElseParamName);
        }
        if (objContion.ElseFormat != "") {
            setElseFormat(tempObj, objContion.ElseFormat);
        }
        if (objContion.ElseEquationRemark != "") {
            setElseEquationRemark(tempObj, objContion.ElseEquationRemark);
        }
        if (objContion.ElseEquationRange != "") {
            setElseEquationRange(tempObj, objContion.ElseEquationRange);
        }
        if (objContion.ElseEquation != "") {
            setElseEquation(tempObj, objContion.ElseEquation);
        }
        if (objContion.ElseRound != "") {
            setElseRound(tempObj, objContion.ElseRound);
        }
    }
}


function setConditionListCurrent(tempObj, property) {
    var conditionList = getCondition(property);
    if (conditionList != null) {
        for (var i = 0; i < conditionList.length; i++) {
            var con = conditionList[i];
            var condition = con.substring(11, con.length - 12);
            setConditionCurrent(tempObj, condition);
        }
    }
}

function setConditionCurrent(tempObj, condition) {
    var objContion = {};
    objContion.ElseType = "";
    objContion.ElseRange = "";
    objContion.ElseRemarks = "";
    objContion.ElseParamName = "";
    objContion.ElseFormat = "";
    objContion.ElseEquationRemark = "";
    objContion.ElseEquationRange = "";
    objContion.ElseEquation = "";
    objContion.ElseValue = "";
    objContion.ElseRound = "";
    var strCon = splitCondition(condition, objContion);
    if (checkCondition(strCon, tempObj.value)) {
        if (objContion.ElseRemarks != "") {
            setElseRemarks(tempObj, objContion.ElseRemarks);
        }
        if (objContion.ElseEquationRemark != "") {
            setElseEquationRemark(tempObj, objContion.ElseEquationRemark);
        }
        if (objContion.ElseRound != "") {
            setElseRound(tempObj, objContion.ElseRound);
        }
    }
}


function setRemarks(tempObj, property) {
    var remark = getRemarks(property);
    tempObj.remark = remark;
}

function setRelationRemark(tempObj, property) {
    var relation = getRelationRemark(property);
    var index = relation.indexOf("<");
    var strData = relation.substring(0, index);
    var value = getRelateValue(relation);
    strData = strData.replace("$", value);
    tempObj.remark = strData;
}

function setRelationRange(tempObj, property) {
    var relation = getRelationRange(property);
    var index = relation.indexOf("<");
    var strData = relation.substring(0, index);
    var value = getRelateValue(relation);
    strData = strData.replace("$", value);
    tempObj.range = strData;
}

function setEquationRange(tempObj, property) {
    var equation = getEquationRange(property);
    var range = replaceEquation(equation);
    tempObj.range = range;
}

function setEquationRemarks(tempObj, property) {
    var equation = getEquationRemarks(property);
    var remark = replaceEquation(equation);
    tempObj.remark = remark;
}

function replaceField(strData) {
    var regx = /<\$.*?\$>/gi;
    var result = strData.match(regx);
    if (result != null) {
        for (var i = 0; i < result.length; i++) {
            var temp = result[i];
            var field = temp.substring(2, temp.length - 2);
            var value = getDataByDisplayName(field);
            strData = strData.replace(temp, value);
        }
    }
    return strData;
}

function replaceEquation(strData) {
    try {
        var regx = /<Equation[^>]*>[\s\S]*?<\/Equation>/gi;
        var result = strData.match(regx);
        if (result != null) {
            for (var i = 0; i < result.length; i++) {
                var temp = result[i];
                var tempdata = temp.substring(10, temp.length - 11);
                var equation = replaceField(tempdata);
                strData = strData.replace(temp, equation);
            }
            strData = getEval(strData);
        }
    } catch (e) { }
    return strData;
}


function getRelateValue(relation) {
    var table = getTable(relation);
    var field = getField(relation);
    var condition = getRelateField(relation);
    var sql = "select " + field + " from Relation" + companyid + "_" + table + condition;
    var value = getRelateTable(sql);
    return value;
}

//需对查询值加引号
function replaceFieldSQL(strData) {
    var regx = /<\$.*?\$>/gi;
    var result = strData.match(regx);
    if (result != null) {
        for (var i = 0; i < result.length; i++) {
            var temp = result[i];
            var field = temp.substring(2, temp.length - 2);
            var value = getDataByDisplayName(field);
            value = "'" + value + "'";
            strData = strData.replace(temp, value);
        }
    }
    return strData;
}


function splitOtherEquation(strData) {
    if (testElseEquationRemark(strData)) {
        var regx = /<ElseEquationRemark[^>]*>[\s\S]*?<\/ElseEquationRemark>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
        }
    }
    if (testElseEquationRange(strData)) {
        var regx = /<ElseEquationRange[^>]*>[\s\S]*?<\/ElseEquationRange>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
        }
    }
    if (testEquationRange(strData)) {
        var regx = /<EquationRange[^>]*>[\s\S]*?<\/EquationRange>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
        }
    }
    if (testEquationRemarks(strData)) {
        var regx = /<EquationRemark[^>]*>[\s\S]*?<\/EquationRemark>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
        }
    }
    return strData;
}



function splitCondition(strData, objContion) {
    strData = splitElseType(strData, objContion);
    strData = splitElseRange(strData, objContion);
    strData = splitElseRemarks(strData, objContion);
    strData = splitElseFormat(strData, objContion);
    strData = splitElseParamName(strData, objContion);
    strData = splitElseValue(strData, objContion);
    strData = splitElseEquationRemark(strData, objContion);
    strData = splitElseEquationRange(strData, objContion);
    strData = splitElseEquation(strData, objContion);
    strData = splitElseRound(strData, objContion);
    return strData;
}


function splitElseType(strData, objContion) {
    if (testElseType(strData)) {
        var regx = /<ElseType[^>]*>[\s\S]*?<\/ElseType>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
            objContion.ElseType = data.substring(10, data.length - 11);
        }
    }
    return strData
}

function splitElseRange(strData, objContion) {
    if (testElseRange(strData)) {
        var regx = /<ElseRange[^>]*>[\s\S]*?<\/ElseRange>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
            objContion.ElseRange = data.substring(11, data.length - 12);
        }
    }
    return strData
}

function splitElseEquation(strData, objContion) {
    if (testElseEquation(strData)) {
        var regx = /<ElseEquation[^>]*>[\s\S]*?<\/ElseEquation>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
            objContion.ElseEquation = data.substring(14, data.length - 15);
        }
    }
    return strData
}

function splitElseFormat(strData, objContion) {
    if (testElseFormat(strData)) {
        var regx = /<ElseFormat[^>]*>[\s\S]*?<\/ElseFormat>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
            objContion.ElseFormat = data.substring(12, data.length - 13);
        }
    }
    return strData;
}

function splitElseRemarks(strData, objContion) {
    if (testElseRemarks(strData)) {
        var regx = /<ElseRemarks[^>]*>[\s\S]*?<\/ElseRemarks>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
            objContion.ElseRemarks = data.substring(13, data.length - 14);
        }
    }
    return strData;
}

function splitElseValue(strData, objContion) {
    if (testElseValue(strData)) {
        var regx = /<ElseValue[^>]*>[\s\S]*?<\/ElseValue>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
            objContion.ElseValue = data.substring(11, data.length - 12);
        }
    }
    return strData;
}

function splitElseParamName(strData, objContion) {
    if (testElseParamName(strData)) {
        var regx = /<ElseParamName[^>]*>[\s\S]*?<\/ElseParamName>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
            objContion.ElseParamName = data.substring(15, data.length - 16);
        }
    }
    return strData;
}

function splitElseEquationRange(strData, objContion) {
    if (testElseEquationRange(strData)) {
        var regx = /<ElseEquationRange[^>]*>[\s\S]*?<\/ElseEquationRange>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
            objContion.ElseEquationRange = data.substring(19, data.length - 20);
        }
    }
    return strData
}

function splitElseEquationRemark(strData, objContion) {
    if (testElseEquationRemark(strData)) {
        var regx = /<ElseEquationRemark[^>]*>[\s\S]*?<\/ElseEquationRemark>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
            objContion.ElseEquationRemark = data.substring(20, data.length - 21);
        }
    }
    return strData
}

function splitElseRound(strData, objContion) {
    if (testElseRound(strData)) {
        var regx = /<ElseRound[^>]*>[\s\S]*?<\/ElseRound>/gi;
        var result = strData.match(regx);
        if (result != null) {
            var data = result[0];
            strData = strData.replace(data, "");
            objContion.ElseRound = data.substring(11, data.length - 12);
        }
    }
    return strData
}


function setElseType(tempObj, type) {
    tempObj.type = type;
}

function setElseRange(tempObj, range) {
    tempObj.range = range;
}

function setElseEquation(tempObj, equation) {
    var value = replaceField(equation);
    tempObj.value = getEval(value);
}

function setElseFormat(tempObj, format) {
    tempObj.value = replaceField(format);
}

function setElseRemarks(tempObj, remark) {
    tempObj.remark = remark;
}

function setElseValue(tempObj, value) {
    tempObj.value = value;
}

function setElseParamName(tempObj, name) {
    tempObj.paramName = name;
}

function setElseEquationRange(tempObj, equation) {
    var range = replaceEquation(equation);
    tempObj.range = range;
}

function setElseEquationRemark(tempObj, equation) {
    var remark = replaceEquation(equation);
    tempObj.remark = remark;
}

function setElseRound(tempObj, name) {
    var curValue = tempObj.value;
    var num = new Number(curValue);
    if (!isNaN(num)) {
        setRoundValue(tempObj, name);
    }
}


function setRoundValue(tempObj, name) {
    var curValue = tempObj.value;
    var num = new Number(curValue);
    if (name == "round") {
        var value = Math.round(curValue);
        if (curValue.indexOf("-") != -1) {
            var abs = Math.abs(curValue);
            abs = Math.round(abs);
            value = "-" + abs;
        }
        if (value == 0) {
            value = 0;
        }
        tempObj.value = value;
    }
    else if (name == "rmax") {
        if (curValue.indexOf(".") == -1 || num == parseInt(num)) {
            tempObj.value = parseInt(num);
        } else {
            if (curValue.indexOf("-") == -1) {
                tempObj.value = parseInt(num) + 1;
            } else {
                tempObj.value = parseInt(num);
            }
        }
    }
    else if (name == "rmin") {
        if (curValue.indexOf(".") == -1 || num == parseInt(num)) {
            tempObj.value = parseInt(num);
        } else {
            if (curValue.indexOf("-") == -1) {
                tempObj.value = parseInt(num);
            } else {
                tempObj.value = parseInt(num) - 1;
            }
        }
    }
}


function checkCondition(contion, value) {
    try {
        var strData = replaceField(contion);
        if (strData != "") {
            strData = strData.replaceAll("or", ";");
            strData = strData.replaceAll("|", ";");
            strData = strData.replaceAll(";;", ";");
            strData = strData.replaceAll(";", "||");
            strData = strData.replaceAll("and", ";");
            strData = strData.replaceAll("&&", ";");
            strData = strData.replaceAll("&", ";");
            strData = strData.replaceAll(";", "&&");

            var tbData = strData;
            tbData = tbData.replaceAll("(", "");
            tbData = tbData.replaceAll(")", "");
            var tbOr = getOrList(tbData);
            for (var i = 0; i < tbOr.length; i++) {
                var tbAnd = getAndList(tbOr[i]);
                var statusAnd = true;
                for (var j = 0; j < tbAnd.length; j++) {
                    var andRes = tbAnd[j];
                    if (andRes.indexOf("isodd") != -1) {
                        var temp = checkOdd(andRes);
                        strData = strData.replace(andRes, temp);
                    } else if (andRes.indexOf("iseven") != -1) {
                        var temp = checkEven(andRes);
                        strData = strData.replace(andRes, temp);
                    } else if (andRes.indexOf("isi") != -1) {
                        var temp = checkIsi(andRes);
                        strData = strData.replace(andRes, temp);
                    } else if (andRes.indexOf("isf") != -1) {
                        var temp = checkIsf(andRes);
                        strData = strData.replace(andRes, temp);
                    }
                }
            }
            return getEval(strData);
        }
        return true;
    } catch (e) {
        return false;
    }
}


//是否为偶数
function checkEven(contion) {
    var data = contion.replace("iseven", "");
    var num = new Number(data);
    if (!isNaN(num)) {
        if (num % 2 == 0) {
            return true;
        }
        else {
            return false;
        }
    }
    else {
        return false;
    }
}
//是否为奇数
function checkOdd(contion) {
    var data = contion.replace("isodd", "");
    var num = new Number(data);
    if (!isNaN(num)) {
        if ((num + 1) % 2 == 0) {
            return true;
        }
        else {
            return false;
        }
    }
    else {
        return false;
    }
}
//是否为整数
function checkIsi(contion) {
    var data = contion.replace("isi", "");
    var num = new Number(data);
    if (!isNaN(num)) {
        if (parseInt(num) == num) {
            return true;
        }
        else {
            return false;
        }
    }
    else {
        return false;
    }
}
//是否有小数
function checkIsf(contion) {
    var data = contion.replace("isf", "");
    var num = new Number(data);
    if (!isNaN(num)) {
        if (parseInt(num) != num) {
            return true;
        }
        else {
            return false;
        }
    }
    else {
        return false;
    }
}
