// Modules to control application life and create native browser window
const {app, BrowserWindow, Menu} = require('electron')
const path = require('path')

function createWindow() {
    // Create the browser window.
    const mainWindow = new BrowserWindow({
        // width: 900,
        // height: 600,
        minWidth: 1024,
        minHeight: 600,
        // maxWidth: 900,
        // maxHeight: 600,
        // frame: false,
        // fullscreen: true
        webPreferences: {
            preload: path.join(__dirname, 'preload.js'),
            enableRemoteModule: true,
            contextIsolation: false,
        }
    })
    Menu.setApplicationMenu(null);

    // if (process.env.NODE_ENV === 'dev') {
    //     mainWindow.loadURL('http://localhost:6663/home')
    // } else {
    //     mainWindow.loadFile(`dist/index.html`);
    // }

    mainWindow.loadURL('https://deec.cc');

    // Open the DevTools.
    // mainWindow.webContents.openDevTools()
}

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can on
// ly be used after this event occurs.
app.whenReady().then(() => {
    createWindow()

    app.on('activate', function () {
        // On macOS it's common to re-create a window in the app when the
        // dock icon is clicked and there are no other windows open.
        if (BrowserWindow.getAllWindows().length === 0) createWindow()
    })
})

// Quit when all windows are closed, except on macOS. There, it's common
// for applications and their menu bar to stay active until the user quits
// explicitly with Cmd + Q.
app.on('window-all-closed', function () {
    if (process.platform !== 'darwin') app.quit()
})

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and require them here.
